
#include "titledialog.h"
#include "qdvd.h"
#include "mainwindow.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qgrid.h>
#include <qhgroupbox.h>
#include <qpushbutton.h>

TitleDialog::TitleDialog(
	QWidget *parent,
	const char *name)
	: QDialog(parent, name, true) // TODO: MAKE FALSE
{
	QVBoxLayout *main = new QVBoxLayout(this, 4, 4);

	QLabel *titleid = new QLabel("DVD Title ID: --", this);

	QHGroupBox *dvdbox = new QHGroupBox("DVD", this);
	QGrid *topgrid = new QGrid(2, dvdbox);
	topgrid->setSpacing(4);
	(void) new QLabel("Title:", topgrid);
	m_pTitle = new QLineEdit(topgrid);
	m_pTitle->setMaxLength(DVD_TITLE_LEN - 1);
	(void) new QLabel("Reference Number:", topgrid);
	m_pReferenceNum = new QLineEdit(topgrid);
	(void) new QLabel("Director:", topgrid);
	m_pDirector = new QLineEdit(topgrid);
	m_pDirector->setMaxLength(NAME_LEN - 1);
	(void) new QLabel("Genre:", topgrid);
	m_pGenre = new QComboBox(true, topgrid);
	m_pGenre->lineEdit()->setMaxLength(GENRE_LEN - 1);

	char **list;
	int count;

	dvd_get_genre_list(&list, &count);

	for(int i = 0; i < count; i++)
		m_pGenre->insertItem(list[i]);
	
	
	(void) new QLabel("Classification:", topgrid);
	m_pClassif = new QComboBox(true, topgrid);
	m_pClassif->lineEdit()->setMaxLength(CLASS_LEN - 1);

	dvd_get_classification_list(&list, &count);
	
	for(int i = 0; i < count; i++)
		m_pClassif->insertItem(list[i]);

	(void) new QLabel("Actor 1:", topgrid);
	m_pActor1 = new QLineEdit(topgrid);
	m_pActor1->setMaxLength(NAME_LEN - 1);
	(void) new QLabel("Actor 2:", topgrid);
	m_pActor2 = new QLineEdit(topgrid);
	m_pActor2->setMaxLength(NAME_LEN - 1);
	(void) new QLabel("Release Date:", topgrid);
	m_pReleaseDate = new QLineEdit(topgrid);
	m_pReleaseDate->setMaxLength(DAY_DATE_LEN - 1);
	(void) new QLabel("Rental Cost:", topgrid);
	m_pRentalCost = new QSpinBox(topgrid);
	m_pRentalCost->setValue(3);

	QPushButton *okay	= new QPushButton("Okay", this);
	connect(okay, SIGNAL(clicked()), this, SLOT(okay()));
	QPushButton *cancel	= new QPushButton("Cancel", this);
	connect(cancel, SIGNAL(clicked()), this, SLOT(close()));

	QHBoxLayout *bottom	= new QHBoxLayout;
	bottom->addStretch();
	bottom->addWidget(okay);
	bottom->addWidget(cancel);
	
	main->addWidget(titleid);
	main->addWidget(dvdbox);
	main->addLayout(bottom);
	main->activate();
}


TitleDialog::~TitleDialog()
{
}


void
TitleDialog::okay()
{
	dvd_title new_title;
	int title_id, rc;
	
	strcpy(new_title.title_text, m_pTitle->text());
	strcpy(new_title.asin, m_pReferenceNum->text());
	strcpy(new_title.director, m_pDirector->text());
	strcpy(new_title.genre, m_pGenre->currentText());
	strcpy(new_title.classification, m_pClassif->currentText());
	strcpy(new_title.actor1, m_pActor1->text());
	strcpy(new_title.actor2, m_pActor2->text());
	strcpy(new_title.release_date, m_pReleaseDate->text());
	strcpy(new_title.rental_cost, m_pRentalCost->cleanText());

	rc = dvd_title_create(&new_title, &title_id);

	QString log;
	log.sprintf("Added title '%s': Title ID %d",
				(const char *)m_pTitle->text(),
				title_id);
	MainWindow::addLog(log);
	
	accept();
}
