
#include "searchwindowpage.h"
#include "settingsmanager.h"

#include <qlayout.h>
#include <qvgroupbox.h>

SearchWindowPage::SearchWindowPage(
	QWidget *parent,
	const char *name)
	: QWidget(parent, name)
{
	QHBoxLayout *main = new QHBoxLayout(this, 4, 4);
	QVGroupBox *left = new QVGroupBox("View Title Field in Search List", this);

	m_pRefNum	= new QCheckBox("Reference Number", left);
	m_pDirector	= new QCheckBox("Director", left);
	m_pGenre	= new QCheckBox("Genre", left);
	m_pClassif	= new QCheckBox("Classification", left);
	m_pActor1	= new QCheckBox("Actor 1", left);
	m_pActor2	= new QCheckBox("Actor 2", left);
	m_pRelDate	= new QCheckBox("Release Date", left);
	m_pRentCost	= new QCheckBox("Rental Cost", left);
	
	QVGroupBox *right = new QVGroupBox("View Member Field in Search List", this);

	m_pTitle	= new QCheckBox("Title", right);
	m_pFirstName= new QCheckBox("First Name", right);
	m_pLastName	= new QCheckBox("Last Name", right);
	m_pHouseNum	= new QCheckBox("House/Flat Number", right);
	m_pAddr1	= new QCheckBox("Address 1", right);
	m_pAddr2	= new QCheckBox("Address 2", right);
	m_pTown		= new QCheckBox("Town", right);
	m_pState	= new QCheckBox("State", right);
	m_pPhone	= new QCheckBox("Phone", right);
	m_pZipCode	= new QCheckBox("Zipcode", right);
	
	main->addWidget(left);
	main->addWidget(right);

	main->activate();
}


SearchWindowPage::~SearchWindowPage()
{
}


/*
  Update the GUI according to the previous settings.
*/

void
SearchWindowPage::readSettings()
{
	SettingsManager *sm = SettingsManager::instance();
	m_pRefNum->setChecked(sm->getBool("show_refnum"));
	m_pDirector->setChecked(sm->getBool("show_director"));
	m_pGenre->setChecked(sm->getBool("show_genre"));
	m_pClassif->setChecked(sm->getBool("show_classif"));
	m_pActor1->setChecked(sm->getBool("show_actor1"));
	m_pActor2->setChecked(sm->getBool("show_actor2"));
	m_pRelDate->setChecked(sm->getBool("show_reldate"));
	m_pRentCost->setChecked(sm->getBool("show_rentcost"));
	m_pTitle->setChecked(sm->getBool("show_title"));
	m_pFirstName->setChecked(sm->getBool("show_firstname"));
	m_pLastName->setChecked(sm->getBool("show_lastname"));
	m_pHouseNum->setChecked(sm->getBool("show_housenum"));
	m_pAddr1->setChecked(sm->getBool("show_addr1"));
	m_pAddr2->setChecked(sm->getBool("show_addr2"));
	m_pTown->setChecked(sm->getBool("show_town"));
	m_pState->setChecked(sm->getBool("show_state"));
	m_pPhone->setChecked(sm->getBool("show_phone"));
	m_pZipCode->setChecked(sm->getBool("show_zipcode"));
}


/*
  Store the current settings of the GUI.
*/

void
SearchWindowPage::saveSettings()
{
	SettingsManager *sm = SettingsManager::instance();
	sm->setBool("show_refnum", m_pRefNum->isChecked());
	sm->setBool("show_director", m_pDirector->isChecked());
	sm->setBool("show_genre", m_pGenre->isChecked());
	sm->setBool("show_classif", m_pClassif->isChecked());
	sm->setBool("show_actor1", m_pActor1->isChecked());
	sm->setBool("show_actor2", m_pActor2->isChecked());
	sm->setBool("show_reldate", m_pRelDate->isChecked());
	sm->setBool("show_rentcost", m_pRentCost->isChecked());
	sm->setBool("show_title", m_pTitle->isChecked());
	sm->setBool("show_firstname", m_pFirstName->isChecked());
	sm->setBool("show_lastname", m_pLastName->isChecked());
	sm->setBool("show_housenum", m_pHouseNum->isChecked());
	sm->setBool("show_addr1", m_pAddr1->isChecked());
	sm->setBool("show_addr2", m_pAddr2->isChecked());
	sm->setBool("show_town", m_pTown->isChecked());
	sm->setBool("show_state", m_pState->isChecked());
	sm->setBool("show_phone", m_pPhone->isChecked());
	sm->setBool("show_zipcode", m_pZipCode->isChecked());
}

