
#include "reservedialog.h"
#include "qdvd.h"
#include "mainwindow.h"

#include <iostream.h>

#include <qgrid.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qdatetime.h>

ReserveDialog::ReserveDialog(
	QWidget *parent,
	const char *name)
	: QDialog(parent, name, true) // TODO: MAKE FALSE
{
	QVBoxLayout *main = new QVBoxLayout(this, 4, 4);
	
	QGrid *grid = new QGrid(2, this);
	grid->setSpacing(4);
	(void) new QLabel("Reserve DVD Title ID:", grid);
	m_pTitleId = new QSpinBox(0, 100000, 1, grid);
	(void) new QLabel("To Member No:", grid);
	m_pMemberNum = new QLineEdit(grid);
	(void) new QLabel("On Date:", grid);
	m_pDate = new QLineEdit(grid);
	QDate d = QDate::currentDate();
	QString str;
	str.sprintf("%d%02d%02d", d.year(), d.month(), d.day());
	m_pDate->setText(str);

	QPushButton *reserve = new QPushButton("Reserve", this);
	connect(reserve, SIGNAL(clicked()), this, SLOT(reserve()));
	QPushButton *cancel	= new QPushButton("Cancel", this);
	connect(cancel, SIGNAL(clicked()), this, SLOT(close()));

	QHBoxLayout *bottom = new QHBoxLayout;
	bottom->addStretch();
	bottom->addWidget(reserve);
	bottom->addWidget(cancel);
	
	main->addWidget(grid);
	main->addLayout(bottom);

	main->activate();
}


ReserveDialog::~ReserveDialog()
{
}


void
ReserveDialog::reserve()
{
	int rc = dvd_reserve_title((const char *)m_pDate->text(),
							   m_pTitleId->text().toInt(),
							   m_pMemberNum->text().toInt());

	if(rc == 0)
	{
		QString log;
		log.sprintf("Reserve title %s for member no. %d on %s",
					(const char *)m_pTitleId->text(),
					(const char *)m_pMemberNum->text(),
					(const char *)m_pDate->text());
		MainWindow::addLog(log);
	}
	else
	{
//		char **msg;
//		dvd_err_text(rc, msg);
//		QMessageBox::warning(this, "DVDstore", msg[0]);
	}

	accept();
}

