
#include "membersearchpage.h"
#include "settingsmanager.h"
#include "qdvd.h"

#include <iostream.h>
#include <stdlib.h>

#include <qgrid.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlistview.h>

MemberSearchPage::MemberSearchPage(
	QWidget *parent,
	const char *name)
	: QWidget(parent, name)
{
	QVBoxLayout *main = new QVBoxLayout(this, 4, 4);
	QHBoxLayout *top = new QHBoxLayout;
	QHBoxLayout *bottom = new QHBoxLayout;

	QLabel *l = new QLabel("Search for:", this);
	m_pSearchFor = new QComboBox(this);
	m_pSearchFor->insertItem("Member No");
	m_pSearchFor->insertItem("Last Name");	
	m_pSearch = new QLineEdit(this);
	QPushButton *search = new QPushButton("Search", this);
	connect(search, SIGNAL(clicked()), this, SLOT(search()));

	top->addWidget(l);
	top->addWidget(m_pSearchFor);
	top->addWidget(m_pSearch);
	top->addWidget(search);
	
	m_pList = new QListView(this);
	m_pList->addColumn("Member No");
	
	SettingsManager *sm = SettingsManager::instance();
	if(sm->getBool("show_title"))
		m_pList->addColumn("Title");
	if(sm->getBool("show_firstname"))
		m_pList->addColumn("First Name");
	if(sm->getBool("show_lastname"))
		m_pList->addColumn("Last Name");
	if(sm->getBool("show_housenum"))
		m_pList->addColumn("House No");
	if(sm->getBool("show_addr1"))
		m_pList->addColumn("Addr1");
	if(sm->getBool("show_addr2"))
		m_pList->addColumn("Addr2");
	if(sm->getBool("show_town"))
		m_pList->addColumn("Town");
	if(sm->getBool("show_state"))
		m_pList->addColumn("State");
	if(sm->getBool("show_phone"))
		m_pList->addColumn("Phone");
	if(sm->getBool("show_zipcode"))
		m_pList->addColumn("Zip");
	
	
	QPushButton *clear = new QPushButton("Clear", this);
	connect(clear, SIGNAL(clicked()), this, SLOT(clear()));

	bottom->addStretch();
	bottom->addWidget(clear);
	
	main->addLayout(top);
	main->addWidget(m_pList);
	main->addLayout(bottom);

	main->activate();
}


MemberSearchPage::~MemberSearchPage()
{
}


void
MemberSearchPage::search()
{
	m_pList->clear();

	int *result;
	int count;
		
	if(m_pSearchFor->currentItem() == 0)
	{
		// Search for member no.

		result = (int*)malloc(1);
		result[0] = m_pSearch->text().toInt();
		count = 1;
	}
	else
	{
		// Search for last name.

		dvd_member_search((const char *)m_pSearch->text(),
						  &result,
						  &count);
	}
	
	dvd_store_member mem;
	QListViewItem *item;
	int colno, rc;
	SettingsManager *sm = SettingsManager::instance();
		
	for(int i = 0; i < count; i++)
	{
		colno = 1;
		rc = dvd_member_get(result[i], &mem);

		if(rc == 0)
		{
			item = new QListViewItem(m_pList);
			item->setText(0, mem.member_no);
			if(sm->getBool("show_title"))
				item->setText(colno++, mem.title);
			if(sm->getBool("show_firstname"))
				item->setText(colno++, mem.fname);
			if(sm->getBool("show_lastname"))
				item->setText(colno++, mem.lname);
			if(sm->getBool("show_housenum"))
				item->setText(colno++, mem.house_flat_ref);
			if(sm->getBool("show_addr1"))
				item->setText(colno++, mem.address1);
			if(sm->getBool("show_addr2"))
				item->setText(colno++, mem.address2);
			if(sm->getBool("show_town"))
				item->setText(colno++, mem.town);
			if(sm->getBool("show_state"))
				item->setText(colno++, mem.state);
			if(sm->getBool("show_phone"))
				item->setText(colno++, mem.phone);
			if(sm->getBool("show_zipcode"))
				item->setText(colno, mem.zipcode);
		}
	}
		
	free(result);
}


void
MemberSearchPage::clear()
{
	m_pList->clear();
}
