
#include <qmainwindow.h>
#include <qtabwidget.h>
#include <qmultilineedit.h>
#include <qlistview.h>
#include <qtoolbar.h>
#include <qpopupmenu.h>
#include <qtoolbutton.h>

#include "preferencesdialog.h"

#ifndef MAINWINDOW_INCLUDED_H
#define MAINWINDOW_INCLUDED_H

class MainWindow : public QMainWindow
{
	Q_OBJECT
public:
	MainWindow();
	virtual ~MainWindow();

	static void addLog(const QString& msg);

private slots:
	void connectDatabase();
	void disconnectDatabase();
	void addMember();
	void addTitle();
	void addDisk();
	void find();
	void rentDVD();
	void returnDVD();
	void reserve();
	void preferences();
	void about();
	void shutdown();
	
private:
	QTabWidget			*m_pCentralWidget;
	static QMultiLineEdit		*m_pLog;
	QListView			*m_pList;
	QToolBar			*m_pToolBar;
	QPopupMenu			*m_pStoreMenu;
	QPopupMenu			*m_pEditMenu;
	PreferencesDialog	*m_pPrefDlg;
	QToolButton			*m_pConnectButton;
	QToolButton			*m_pDisconnectButton;
	QToolButton			*m_pRentButton;
	QToolButton			*m_pReturnButton;
	QToolButton			*m_pReserveButton;
	QToolButton			*m_pSearchButton;
	QToolButton			*m_pAddButton;
	int					m_ConnectItem;
	int					m_DisconnectItem;
	int					m_AddMemberItem;
	int					m_NewTitleItem;
	int					m_NewDiskItem;
	int					m_FindItem;
	int					m_RentItem;
	int					m_ReturnItem;
	int					m_ReserveItem;
};

#endif // MAINWINDOW_INCLUDED_H
