
#include "mainwindow.h"
#include "connectdialog.h"
#include "memberdialog.h"
#include "titledialog.h"
#include "searchdialog.h"
#include "rentdialog.h"
#include "returndialog.h"
#include "reservedialog.h"
#include "settingsmanager.h"

#include "qdvd.h"

#include <iostream.h>

#include <qapplication.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qdatetime.h>
#include <qmessagebox.h>
#include <qtoolbutton.h>
#include <qstatusbar.h>
#include <qinputdialog.h>
#include <qpixmap.h>
#include <qfile.h>
#include <qtextstream.h>

QMultiLineEdit *MainWindow::m_pLog = 0;

MainWindow::MainWindow()
	: QMainWindow(0, "dvdstore")
{
	m_pPrefDlg = 0;
	
	setCaption("DVDstore");
	
	m_pStoreMenu = new QPopupMenu(this);
	m_pStoreMenu->insertTearOffHandle();
	m_ConnectItem = m_pStoreMenu->insertItem("&Connect...", this, SLOT(connectDatabase()));
	m_DisconnectItem = m_pStoreMenu->insertItem("&Disconnect", this, SLOT(disconnectDatabase()));
	m_pStoreMenu->insertSeparator();
	m_AddMemberItem = m_pStoreMenu->insertItem("Add Member...", this, SLOT(addMember()), CTRL + Key_M);
	m_NewTitleItem = m_pStoreMenu->insertItem("New Title...", this, SLOT(addTitle()), CTRL + Key_T);
	m_NewDiskItem = m_pStoreMenu->insertItem("New Disk...", this, SLOT(addDisk()), CTRL + Key_M);
	m_pStoreMenu->insertSeparator();
	m_pStoreMenu->insertItem("&Exit", this, SLOT(shutdown()), CTRL + Key_Q);

	m_pEditMenu = new QPopupMenu(this);
	m_pEditMenu->insertTearOffHandle();
	m_FindItem = m_pEditMenu->insertItem("&Find...", this, SLOT(find()), Key_F6);
	m_pEditMenu->insertSeparator();
	m_RentItem = m_pEditMenu->insertItem("Rent DVD...", this, SLOT(rentDVD()), Key_F7);
	m_ReturnItem = m_pEditMenu->insertItem("Return DVD...", this, SLOT(returnDVD()), Key_F8);
	m_ReserveItem = m_pEditMenu->insertItem("Reserve...", this, SLOT(reserve()), Key_F9);

	
	QPopupMenu *settings = new QPopupMenu(this);
	settings->insertTearOffHandle();
	settings->insertItem("Preferences...", this, SLOT(preferences()), Key_F5);


	QPopupMenu *help = new QPopupMenu(this);
	help->insertTearOffHandle();
	help->insertItem("About...", this, SLOT(about()));
	

	menuBar()->insertItem("&DVDstore", m_pStoreMenu);
	menuBar()->insertItem("&Edit", m_pEditMenu);
	menuBar()->insertItem("&Settings", settings);
	menuBar()->insertSeparator();
	menuBar()->insertItem("&Help", help);

	
	m_pStoreMenu->setItemEnabled(m_DisconnectItem, false);
	m_pStoreMenu->setItemEnabled(m_AddMemberItem, false);
	m_pStoreMenu->setItemEnabled(m_NewTitleItem, false);
	m_pStoreMenu->setItemEnabled(m_NewDiskItem, false);
	m_pEditMenu->setItemEnabled(m_FindItem, false);
	m_pEditMenu->setItemEnabled(m_RentItem, false);
	m_pEditMenu->setItemEnabled(m_ReturnItem, false);
	m_pEditMenu->setItemEnabled(m_ReserveItem, false);

	m_pToolBar = new QToolBar("toolbar", this);
	QToolButton *tb;
	m_pConnectButton = new QToolButton(
		QPixmap("/usr/share/icons/socket.xpm"),
		"Connect",
		"Connect to database",
		this,
		SLOT(connectDatabase()),
		m_pToolBar);

	m_pDisconnectButton = new QToolButton(
		QPixmap("/usr/share/icons/bomb.xpm"),
		"Disconnect",
		"Disconnect from database",
		this,
		SLOT(disconnectDatabase()),
		m_pToolBar);

	m_pToolBar->addSeparator();

	m_pRentButton = new QToolButton(
		QPixmap("/usr/share/icons/cdrom_unmount.xpm"),
		"Rent",
		"Rent disk",
		this,
		SLOT(rentDVD()),
		m_pToolBar);

	m_pReturnButton = new QToolButton(
		QPixmap("/usr/share/icons/ark.xpm"),
		"Return",
		"Return disk",
		this,
		SLOT(returnDVD()),
		m_pToolBar);

	m_pReserveButton = new QToolButton(
		QPixmap("/usr/share/icons/editors_package.xpm"),
		"Reserve",
		"Reserve disk",
		this,
		SLOT(reserve()),
		m_pToolBar);

	m_pSearchButton = new QToolButton(
		QPixmap("/usr/share/icons/kfind.xpm"),
		"Search",
		"Search for DVD, member or disk.",
		this,
		SLOT(find()),
		m_pToolBar);

	m_pToolBar->addSeparator();

	m_pAddButton = new QToolButton(
		QPixmap("/usr/share/icons/kcmpartitions.xpm"),
		"Add",
		"Add new member",
		this,
		SLOT(addMember()),
		m_pToolBar);

	m_pToolBar->addSeparator();

	tb = new QToolButton(
		QPixmap("/usr/share/icons/kcmx.xpm"),
		"Exit",
		"Exit DVDstore",
		this,
		SLOT(shutdown()),
		m_pToolBar);


	addToolBar(m_pToolBar);
	setUsesTextLabel(true);

	m_pDisconnectButton->setEnabled(false);
	m_pRentButton->setEnabled(false);
	m_pReturnButton->setEnabled(false);
	m_pReserveButton->setEnabled(false);
	m_pSearchButton->setEnabled(false);
	m_pAddButton->setEnabled(false);
	
	m_pCentralWidget = new QTabWidget(this);
	m_pLog = new QMultiLineEdit(m_pCentralWidget);
	m_pLog->setReadOnly(true);

	m_pList = new QListView(m_pCentralWidget);
	m_pList->addColumn("Member No.");
	m_pList->addColumn("DVD");
	m_pList->addColumn("Title");
	m_pList->addColumn("Due Back");
	
	m_pCentralWidget->addTab(m_pLog, "DVDStore");
	m_pCentralWidget->addTab(m_pList, "On Loan");

	setCentralWidget(m_pCentralWidget);

	resize(460, 300);
}


MainWindow::~MainWindow()
{
	QString logfile = SettingsManager::instance()->getString("logfile");
	if(logfile == "")
		logfile = "logfile.txt";

	QFile f(logfile);

	if(f.open(IO_WriteOnly | IO_Raw | IO_Append))
	{
		QTextStream s(&f);
		s << m_pLog->text();
		s << "\n";
		f.close();
	}
}


void
MainWindow::connectDatabase()
{
	ConnectDialog dlg(this);
	int rc = dlg.exec();

	if(rc == 1)
	{
		m_pStoreMenu->setItemEnabled(m_ConnectItem, false);
		m_pStoreMenu->setItemEnabled(m_DisconnectItem, true);
		m_pStoreMenu->setItemEnabled(m_AddMemberItem, true);
		m_pStoreMenu->setItemEnabled(m_NewTitleItem, true);
		m_pStoreMenu->setItemEnabled(m_NewDiskItem, true);
		m_pEditMenu->setItemEnabled(m_FindItem, true);
		m_pEditMenu->setItemEnabled(m_RentItem, true);
		m_pEditMenu->setItemEnabled(m_ReturnItem, true);
		m_pEditMenu->setItemEnabled(m_ReserveItem, true);

		m_pConnectButton->setEnabled(false);
		m_pDisconnectButton->setEnabled(true);
		m_pRentButton->setEnabled(true);
		m_pReturnButton->setEnabled(true);
		m_pReserveButton->setEnabled(true);
		m_pSearchButton->setEnabled(true);
		m_pAddButton->setEnabled(true);
	}
}


void
MainWindow::disconnectDatabase()
{
	dvd_close_db();
	
	m_pStoreMenu->setItemEnabled(m_ConnectItem, true);
	m_pStoreMenu->setItemEnabled(m_DisconnectItem, false);
	m_pStoreMenu->setItemEnabled(m_AddMemberItem, false);
	m_pStoreMenu->setItemEnabled(m_NewTitleItem, false);
	m_pStoreMenu->setItemEnabled(m_NewDiskItem, false);
	m_pEditMenu->setItemEnabled(m_FindItem, false);
	m_pEditMenu->setItemEnabled(m_RentItem, false);
	m_pEditMenu->setItemEnabled(m_ReturnItem, false);
	m_pEditMenu->setItemEnabled(m_ReserveItem, false);

	m_pConnectButton->setEnabled(true);
	m_pDisconnectButton->setEnabled(false);
	m_pRentButton->setEnabled(false);
	m_pReturnButton->setEnabled(false);
	m_pReserveButton->setEnabled(false);
	m_pSearchButton->setEnabled(false);
	m_pAddButton->setEnabled(false);

	addLog("Disconnected from the database");
}


void
MainWindow::addMember()
{
	MemberDialog dlg(this);
	dlg.show();
}


void
MainWindow::addTitle()
{
	TitleDialog dlg(this);
	dlg.show();
}


void
MainWindow::addDisk()
{
	bool ok;
	int title_id = QInputDialog::getInteger(
		"Add Disk",
		"Add a Disk record to Title ID",
		0, 0, 100000, 1, &ok);

	if(ok)
	{
		dvd_disk disk;
		int disk_id;
		dvd_disk_create(&disk, &disk_id);
		QString str;
		str.sprintf("Created Disk ID %d for Title ID %d",
					disk_id, title_id);
		addLog(str);
		QMessageBox::information(this, "DVDstore", str, "Okay");
	}
}


void
MainWindow::find()
{
	SearchDialog dlg(this);
	dlg.show();
}



void
MainWindow::rentDVD()
{
	RentDialog dlg(0, this);
	dlg.show();
}



void
MainWindow::returnDVD()
{
	ReturnDialog dlg(this);
	dlg.show();
}



void
MainWindow::reserve()
{
	ReserveDialog dlg(this);
	dlg.show();
}


void
MainWindow::preferences()
{
	PreferencesDialog dlg(this);
	dlg.show();
}


void
MainWindow::about()
{
	QMessageBox::about(this, "DVDstore",
					   "DVDstore\n"
					   "\n"
					   "Author: Marius Sundbakken <marius@sundbakken.org>\n\n"
					   "A Qt GUI for the DVDstore conceived in\n"
					   "'Professional Linux Programming'\n"
					   "Wrox Press 2000");	
}


void
MainWindow::shutdown()
{
	int rc = QMessageBox::warning(this, "DVDstore",
								  "Are you sure you want to quit?",
								  "Yes", "No");

	if(rc == 0)
	{
		dvd_close_db();
		qApp->quit();
	}
}


void
MainWindow::addLog(
	const QString& msg)
{
	QTime t = QTime::currentTime();
	QDate d = QDate::currentDate();
	QString str;
	str.sprintf("%02d:%02d %02d/%02d/%02d -- %s",
				t.hour(),
				t.minute(),
				d.month(),
				d.day(),
				d.year(),
				(const char *)msg);

	if(m_pLog == 0)
		cout << str << endl;
	else
		m_pLog->insertLine(str);
}

