
#include "generalpage.h"
#include "settingsmanager.h"

#include <qlayout.h>
#include <qhgroupbox.h>

GeneralPage::GeneralPage(
	QWidget *parent,
	const char *name)
	: QWidget(parent, name)
{
	QVBoxLayout *main = new QVBoxLayout(this, 4, 4);
	QHGroupBox *top = new QHGroupBox("Log File Name", this);
	m_pLogFile = new QLineEdit(top);
	
	top->setFixedHeight(top->sizeHint().height());

	QHGroupBox *bottom = new QHGroupBox("Maximum renting period before overdue", this);
	m_pDays = new QSpinBox(0, 100, 1, bottom);
	m_pDays->setSuffix(" days");

	bottom->setFixedHeight(top->sizeHint().height());
	
	main->addWidget(top);
	main->addWidget(bottom);
	main->addStretch();

	main->activate();
}


GeneralPage::~GeneralPage()
{
}


/*
  Update the GUI according to the previous settings.
*/

void
GeneralPage::readSettings()
{
	SettingsManager *sm = SettingsManager::instance();

	if( ! sm->isSet("logfile"))
		sm->set("logfile", "logfile.txt");
	m_pLogFile->setText(sm->getString("logfile"));

	if( ! sm->isSet("maxrent"))
		sm->set("maxrent", "3");
	m_pDays->setValue(sm->getValue("maxrent"));
}


/*
  Store the current settings of the GUI.
*/

void
GeneralPage::saveSettings()
{
	SettingsManager *sm = SettingsManager::instance();
	sm->set("logfile", m_pLogFile->text());
	sm->set("maxrent", m_pDays->cleanText());
}
