
#include "connectdialog.h"
#include "qdvd.h"
#include "mainwindow.h"

#include <iostream.h>

#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qmessagebox.h>

ConnectDialog::ConnectDialog(
	QWidget *parent,
	const char *name)
	: QDialog(parent, name, true)
{
	QVBoxLayout *main	= new QVBoxLayout(this, 4, 4);
	QGridLayout *top	= new QGridLayout(2, 2);
	QHBoxLayout *bottom	= new QHBoxLayout;

	QLabel *l1	= new QLabel("User Name", this);
	QLabel *l2	= new QLabel("Password", this);
	m_pUserName	= new QComboBox(true, this);
	m_pPassword	= new QLineEdit(this);
	m_pPassword->setEchoMode(QLineEdit::Password);
	
	QPushButton *okay	= new QPushButton("Okay", this);
	okay->setDefault(true);
	connect(okay, SIGNAL(clicked()), this, SLOT(okay()));
	QPushButton *cancel	= new QPushButton("Cancel", this);
	connect(cancel, SIGNAL(clicked()), this, SLOT(close()));

	top->addWidget(l1, 0, 0);
	top->addWidget(l2, 1, 0);
	top->addWidget(m_pUserName, 0, 1);
	top->addWidget(m_pPassword, 1, 1);

	bottom->addStretch();
	bottom->addWidget(okay);
	bottom->addWidget(cancel);
	
	main->addLayout(top);
	main->addLayout(bottom);

	main->activate();
}


ConnectDialog::~ConnectDialog()
{
}


void
ConnectDialog::okay()
{
	int rc = dvd_open_db_login(m_pUserName->currentText(),
							   m_pPassword->text());

	if(rc != 0)
	{
		QMessageBox::critical(
			this, "DVDstore",
			"DVDStore Error:\n\n"
			"Cannot connect to database. Check that the username\n"
			"and password are correct and that the database is\n"
			"set up correctly.",
			"Okay");
		reject();
	}
	else
	{
		QString str;
		str.sprintf("User %s connected to the database",
					(const char *)m_pUserName->currentText());
		MainWindow::addLog(str);
		accept();
	}
}
