
#include <qdict.h>

class SettingsManager
{
public:
	virtual ~SettingsManager();

	static SettingsManager* instance();

	bool	isSet(const QString& key) const;
	void	setBool(const QString& key, bool value);
	void	set(const QString& key, const QString& value);
	bool	getBool(const QString& key) const;
	QString	getString(const QString& key) const;
	int		getValue(const QString& key) const;
	void	save();
	void	load();
	
private:
	SettingsManager();

	QDict<QString> m_Settings;
	static SettingsManager *m_pInstance;
};
