
#include "renteddialog.h"
#include "qdvd.h"
#include "mainwindow.h"

#include <qlayout.h>
#include <qvgroupbox.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qlabel.h>

RentedDialog::RentedDialog(
	int member_id,
	QList<int> &titlelist,
	QWidget *parent,
	const char *name)
	: QDialog(parent, name, true)
{
	QVBoxLayout *main = new QVBoxLayout(this, 4, 4);
	QHBoxLayout *top = new QHBoxLayout;
	QHBoxLayout *bottom = new QHBoxLayout;

	QString str = "Member ";
	str += QString::number(member_id);
	QVGroupBox *box = new QVGroupBox(str, this);
	dvd_store_member mem;
	dvd_member_get(member_id, &mem);
	str.sprintf("%s %s %s", mem.title, mem.fname, mem.lname);
	QLabel *l;
	l = new QLabel(str, box);
	l->setAlignment(AlignCenter);
	l = new QLabel(mem.house_flat_ref, box);
	l->setAlignment(AlignCenter);
	l = new QLabel(mem.address1, box);
	l->setAlignment(AlignCenter);
	l = new QLabel(mem.address2, box);
	l->setAlignment(AlignCenter);

	QListView *list = new QListView(this);
	list->addColumn("Title ID");
	list->addColumn("Title");
	list->addColumn("  ");
	list->addColumn("Disk ID to Rent");

	QListIterator<int> it(titlelist);
	int disk_id, rc;
	QListViewItem *item;
	QString log;
	
	for(int *title = it.toFirst(); title != 0; title = ++it)
	{
		rc = dvd_rent_title(member_id, *title, &disk_id);
		item = new QListViewItem(list);
		item->setText(0, QString::number(*title));
		item->setText(1, findTitle(*title));
		if(rc == 0)
		{
			item->setText(2, "OK");
			log.sprintf("Rented disk %d to Member: %d",
						disk_id,
						member_id);
			MainWindow::addLog(log);
		}
		else
			item->setText(2, "N/A");
		item->setText(3, QString::number(disk_id));
	}
	
	QPushButton *okay = new QPushButton("Okay", this);
	connect(okay, SIGNAL(clicked()), this, SLOT(close()));
	
	top->addWidget(box);
	top->addWidget(list);

	bottom->addStretch();
	bottom->addWidget(okay);

	main->addLayout(top);
	main->addLayout(bottom);

	main->activate();
}


RentedDialog::~RentedDialog()
{
}


QString
RentedDialog::findTitle(
	int title_id)
{
	dvd_title dvd;
	int rc = dvd_title_get(title_id, &dvd);

	QString str;
	
	if(rc == 0)
		str = dvd.title_text;
	else
		str = "<< NOT FOUND >>";

	return str;
}

