
#include "rentdialog.h"
#include "renteddialog.h"
#include "qdvd.h"

#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qhbox.h>
#include <qvgroupbox.h>
#include <qmessagebox.h>

RentDialog::RentDialog(
	int title_id,
	QWidget *parent,
	const char *name)
	: QDialog(parent, name, true) // TODO: MAKE FALSE
{
	QVBoxLayout *main	= new QVBoxLayout(this, 4, 4);
	QHBoxLayout *top	= new QHBoxLayout;
	QHBoxLayout *bottom	= new QHBoxLayout;

	QLabel *l;
	l = new QLabel("Rent Titles to Member No:", this);
	m_pMember = new QLineEdit(this);

	top->addWidget(l);
	top->addWidget(m_pMember);

	QVGroupBox *rentbox = new QVGroupBox("List of Title IDs to Rent", this);
	QHBox *topbox = new QHBox(rentbox);
	topbox->setSpacing(4);
	l = new QLabel("Title ID:", topbox);
	l->setFixedSize(l->sizeHint());
	m_pTitleId = new QSpinBox(0, 100000, 1, topbox);
	if(title_id > 0)
		m_pTitleId->setValue(title_id);
	QPushButton *add = new QPushButton("Add", topbox);
	connect(add, SIGNAL(clicked()), this, SLOT(add()));

	m_pList = new QListView(rentbox);
	m_pList->addColumn("Title ID");
	m_pList->addColumn("Title");
	
	QPushButton *remove = new QPushButton("Remove", rentbox);
	connect(remove, SIGNAL(clicked()), this, SLOT(remove()));

	QPushButton *rent	= new QPushButton("Rent", this);
	connect(rent, SIGNAL(clicked()), this, SLOT(rent()));
	QPushButton *cancel	= new QPushButton("Cancel", this);
	connect(cancel, SIGNAL(clicked()), this, SLOT(close()));

	bottom->addStretch();
	bottom->addWidget(rent);
	bottom->addWidget(cancel);
	
	main->addLayout(top);
	main->addWidget(rentbox);
	main->addLayout(bottom);

	main->activate();
}


RentDialog::~RentDialog()
{
}


void
RentDialog::add()
{
	dvd_title dvd;
	dvd_title_get(m_pTitleId->text().toInt(), &dvd);
	QListViewItem *item = new QListViewItem(m_pList);
	item->setText(0, m_pTitleId->text());
	item->setText(1, dvd.title_text);
}


void
RentDialog::rent()
{
	dvd_store_member mem;
	int member_id = m_pMember->text().toInt();
	int rc = dvd_member_get(member_id, &mem);

	if(rc != 0)
	{
		QMessageBox::warning(this, "DVDstore", "No such member");
	}
	else
	{	
		QListViewItem *item = m_pList->firstChild();

		QList<int> titlelist;
		titlelist.setAutoDelete(true);
	
		while(item != 0)
		{
			titlelist.append(new int(item->text(0).toInt()));
			item = item->nextSibling();
		}

		hide();

		RentedDialog dlg(member_id, titlelist, this);
		dlg.show();

		accept();
	}
}


void
RentDialog::remove()
{
	delete m_pList->selectedItem();
}



