
#include "preferencesdialog.h"

#include <iostream.h>

PreferencesDialog::PreferencesDialog(
	QWidget *parent,
	const char *name)
	: QTabDialog(parent, name, true) // TODO: MAKE FALSE
{
	setOkButton();
	setApplyButton();
	setCancelButton();
	setHelpButton();

	connect(this, SIGNAL(applyButtonPressed()), this, SLOT(saveSettings()));
	connect(this, SIGNAL(aboutToShow()), this, SLOT(readSettings()));
	
	m_pPage1 = new GeneralPage(this);
	m_pPage2 = new SearchWindowPage(this);
	addTab(m_pPage1, "General");
	addTab(m_pPage2, "Search Window");
}


PreferencesDialog::~PreferencesDialog()
{
}


void
PreferencesDialog::saveSettings()
{
	cout << "save" << endl;

	m_pPage1->saveSettings();
	m_pPage2->saveSettings();
}


void
PreferencesDialog::readSettings()
{
	cout << "read" << endl;
	
	m_pPage1->readSettings();
	m_pPage2->readSettings();
}
