
#include "memberdialog.h"
#include "qdvd.h"
#include "mainwindow.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qgrid.h>
#include <qhgroupbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qmessagebox.h>

MemberDialog::MemberDialog(
	QWidget *parent,
	const char *name)
	: QDialog(parent, name, true) // TODO: MAKE FALSE
{
	QVBoxLayout *main = new QVBoxLayout(this, 4, 4);

	QLabel *memnum = new QLabel("Member Number: --", this);

	QHGroupBox *namebox = new QHGroupBox("Name", this);
	QGrid *topgrid = new QGrid(2, namebox);
	topgrid->setSpacing(4);
	(void) new QLabel("Title:", topgrid);
	m_pTitle = new QLineEdit(topgrid);
	m_pTitle->setMaxLength(PERSON_TITLE_LEN - 1);
	(void) new QLabel("First name:", topgrid);
	m_pFirstName = new QLineEdit(topgrid);
	m_pFirstName->setMaxLength(NAME_LEN - 1);
	(void) new QLabel("Last name:", topgrid);
	m_pLastName = new QLineEdit(topgrid);
	m_pLastName->setMaxLength(NAME_LEN - 1);

	QHGroupBox *addressbox = new QHGroupBox("Address", this);
	QGrid *bottomgrid = new QGrid(2, addressbox);
	bottomgrid->setSpacing(4);
	(void) new QLabel("House no.", bottomgrid);
	m_pHouseNum = new QLineEdit(bottomgrid);
	m_pHouseNum->setMaxLength(NAME_LEN - 1);
	(void) new QLabel("Address 1:", bottomgrid);
	m_pAddr1 = new QLineEdit(bottomgrid);
	m_pAddr1->setMaxLength(ADDRESS_LEN - 1);
	(void) new QLabel("Address 2:", bottomgrid);
	m_pAddr2 = new QLineEdit(bottomgrid);
	m_pAddr2->setMaxLength(ADDRESS_LEN - 1);
	(void) new QLabel("Town:", bottomgrid);
	m_pTown = new QLineEdit(bottomgrid);
	m_pTown->setMaxLength(ADDRESS_LEN - 1);
	(void) new QLabel("State:", bottomgrid);
	m_pState = new QLineEdit(bottomgrid);
	m_pState->setMaxLength(STATE_LEN - 1);
	(void) new QLabel("Zip:", bottomgrid);
	m_pZip = new QLineEdit(bottomgrid);
	m_pZip->setMaxLength(ZIP_CODE_LEN - 1);
	(void) new QLabel("Phone:", bottomgrid);
	m_pPhone = new QLineEdit(bottomgrid);
	m_pPhone->setMaxLength(PHONE_NO_LEN - 1);

	QPushButton *okay	= new QPushButton("Okay", this);
	connect(okay, SIGNAL(clicked()), this, SLOT(okay()));
	QPushButton *cancel	= new QPushButton("Cancel", this);
	connect(cancel, SIGNAL(clicked()), this, SLOT(close()));

	QHBoxLayout *bottom	= new QHBoxLayout;
	bottom->addStretch();
	bottom->addWidget(okay);
	bottom->addWidget(cancel);
	
	main->addWidget(memnum);
	main->addWidget(namebox);
	main->addWidget(addressbox);
	main->addLayout(bottom);
	main->activate();
}


MemberDialog::~MemberDialog()
{
}


void
MemberDialog::okay()
{
	dvd_store_member new_member;
	strcpy(new_member.title, m_pTitle->text());
	strcpy(new_member.fname, m_pFirstName->text());
	strcpy(new_member.lname, m_pLastName->text());
	strcpy(new_member.house_flat_ref, m_pHouseNum->text());
	strcpy(new_member.address1, m_pAddr1->text());
	strcpy(new_member.address2, m_pAddr2->text());
	strcpy(new_member.town, m_pTown->text());
	strcpy(new_member.state, m_pState->text());
	strcpy(new_member.zipcode, m_pZip->text());
	strcpy(new_member.phone, m_pPhone->text());

	int mem_id;
	int rc = dvd_member_create(&new_member, &mem_id);

	if(rc == 0)
	{
		QString str;
		str.sprintf("%s %s %s added as new member. Member no. %d",
					(const char *)m_pTitle->text(),
					(const char *)m_pFirstName->text(),
					(const char *)m_pLastName->text(),
					mem_id);

		MainWindow::addLog(str);
		QMessageBox::information(this, "DVDstore", str, "Okay");
	}
	else
	{
		QMessageBox::warning(this, "DVDstore",
							 "Failed to add member.",
							 "Okay");
	}
	
	
	accept();
}

