
#include <ktmainwindow.h>
#include <qtabwidget.h>
#include <qmultilinedit.h>
#include <qlistview.h>
#include <ktoolbar.h>
#include <qpopupmenu.h>

#include "preferencesdialog.h"

#ifndef MAINWINDOW_INCLUDED_H
#define MAINWINDOW_INCLUDED_H

class MainWindow : public KTMainWindow
{
	Q_OBJECT
public:
	MainWindow();
	virtual ~MainWindow();

	static void addLog(const QString& msg);

private slots:
	void connectDatabase();
	void disconnectDatabase();
	void addMember();
	void addTitle();
	void addDisk();
	void find();
	void rentDVD();
	void returnDVD();
	void reserve();
	void preferences();
	void about();
	void shutdown();
	
private:
	QTabWidget			*m_pCentralWidget;
	static QMultiLineEdit		*m_pLog;
	QListView			*m_pList;
	KToolBar			*m_pToolBar;
	QPopupMenu			*m_pStoreMenu;
	QPopupMenu			*m_pEditMenu;
	PreferencesDialog	*m_pPrefDlg;
	int					m_ConnectButton;
	int					m_DisconnectButton;
	int					m_RentButton;
	int					m_ReturnButton;
	int					m_ReserveButton;
	int					m_SearchButton;
	int					m_AddButton;
	int					m_ConnectItem;
	int					m_DisconnectItem;
	int					m_AddMemberItem;
	int					m_NewTitleItem;
	int					m_NewDiskItem;
	int					m_FindItem;
	int					m_RentItem;
	int					m_ReturnItem;
	int					m_ReserveItem;
};

#endif // MAINWINDOW_INCLUDED_H
