
#include "mainwindow.h"
#include "connectdialog.h"
#include "memberdialog.h"
#include "titledialog.h"
#include "searchdialog.h"
#include "rentdialog.h"
#include "returndialog.h"
#include "reservedialog.h"
#include "settingsmanager.h"

#include "qdvd.h"

#include <iostream.h>

#include <qapplication.h>
#include <qpopupmenu.h>
#include <kmenubar.h>
#include <qdatetime.h>
#include <qmessagebox.h>
#include <qtoolbutton.h>
#include <qstatusbar.h>
#include <qinputdialog.h>
#include <qpixmap.h>
#include <qfile.h>
#include <qtextstream.h>
#include <klocale.h>

QMultiLineEdit *MainWindow::m_pLog = 0;

MainWindow::MainWindow()
{
	m_pPrefDlg = 0;
	
	setCaption("DVDstore");
	
	m_pStoreMenu = new QPopupMenu(this);
	m_pStoreMenu->insertTearOffHandle();
	m_ConnectItem = m_pStoreMenu->insertItem("&Connect...", this, SLOT(connectDatabase()));
	m_DisconnectItem = m_pStoreMenu->insertItem("&Disconnect", this, SLOT(disconnectDatabase()));
	m_pStoreMenu->insertSeparator();
	m_AddMemberItem = m_pStoreMenu->insertItem("Add Member...", this, SLOT(addMember()), CTRL + Key_M);
	m_NewTitleItem = m_pStoreMenu->insertItem("New Title...", this, SLOT(addTitle()), CTRL + Key_T);
	m_NewDiskItem = m_pStoreMenu->insertItem("New Disk...", this, SLOT(addDisk()), CTRL + Key_M);
	m_pStoreMenu->insertSeparator();
	m_pStoreMenu->insertItem("&Exit", this, SLOT(shutdown()), CTRL + Key_Q);

	m_pEditMenu = new QPopupMenu(this);
	m_pEditMenu->insertTearOffHandle();
	m_FindItem = m_pEditMenu->insertItem("&Find...", this, SLOT(find()), Key_F6);
	m_pEditMenu->insertSeparator();
	m_RentItem = m_pEditMenu->insertItem("Rent DVD...", this, SLOT(rentDVD()), Key_F7);
	m_ReturnItem = m_pEditMenu->insertItem("Return DVD...", this, SLOT(returnDVD()), Key_F8);
	m_ReserveItem = m_pEditMenu->insertItem("Reserve...", this, SLOT(reserve()), Key_F9);

	
	QPopupMenu *settings = new QPopupMenu(this);
	settings->insertTearOffHandle();
	settings->insertItem("Preferences...", this, SLOT(preferences()), Key_F5);


	QPopupMenu *help = new QPopupMenu(this);
	help->insertTearOffHandle();
	help->insertItem("About...", this, SLOT(about()));

	menuBar()->insertItem("&DVDstore", m_pStoreMenu);
	menuBar()->insertItem("&Edit", m_pEditMenu);
	menuBar()->insertItem("&Settings", settings);
	menuBar()->insertSeparator();
	menuBar()->insertItem("&Help", help);

	
	m_pStoreMenu->setItemEnabled(m_DisconnectItem, false);
	m_pStoreMenu->setItemEnabled(m_AddMemberItem, false);
	m_pStoreMenu->setItemEnabled(m_NewTitleItem, false);
	m_pStoreMenu->setItemEnabled(m_NewDiskItem, false);
	m_pEditMenu->setItemEnabled(m_FindItem, false);
	m_pEditMenu->setItemEnabled(m_RentItem, false);
	m_pEditMenu->setItemEnabled(m_ReturnItem, false);
	m_pEditMenu->setItemEnabled(m_ReserveItem, false);

	m_pToolBar = new KToolBar(this);
	m_pToolBar->insertButton(
		QPixmap("/opt/kde2/share/icons/hicolor/32x32/filesystems/socket.png"),
		m_ConnectButton,
		SIGNAL(clicked()),
		this,
		SLOT(connectDatabase()),
		true,
		i18n("Connect"));

	m_pToolBar->insertButton(
		QPixmap("/opt/kde2/share/icons/hicolor/32x32/actions/stop.png"),
		m_DisconnectButton,
		SIGNAL(clicked()),
		this,
		SLOT(disconnectDatabase()),
		true,
		i18n("Disconnect"));

	m_pToolBar->insertSeparator();

	m_pToolBar->insertButton(
		QPixmap("/opt/kde2/share/icons/hicolor/32x32/devices/cdrom_unmount.png"),
		m_RentButton,
		SIGNAL(clicked()),
		this,
		SLOT(rentDVD()),
		true,
		i18n("Rent"));

	m_pToolBar->insertButton(
		QPixmap("/opt/kde2/share/icons/hicolor/32x32/actions/toggle_log.png"),
		m_ReturnButton,
		SIGNAL(clicked()),
		this,
		SLOT(returnDVD()),
		true,
		i18n("Return"));

	m_pToolBar->insertButton(
		QPixmap("/opt/kde2/share/icons/hicolor/32x32/actions/message_get.png"),
		m_ReserveButton,
		SIGNAL(clicked()),
		this,
		SLOT(reserve()),
		true,
		i18n("Reserve"));

	m_pToolBar->insertButton(
		QPixmap("/opt/kde2/share/icons/hicolor/32x32/actions/goto.png"),
		m_SearchButton,
		SIGNAL(clicked()),
		this,
		SLOT(find()),
		true,
		i18n("Search"));

	m_pToolBar->insertSeparator();

	m_pToolBar->insertButton(
		QPixmap("/opt/kde2/share/icons/hicolor/32x32/apps/kcmpartitions.png"),
		m_AddButton,
		SIGNAL(clicked()),
		this,
		SLOT(addMember()),
		false,
		i18n("Add"));

	m_pToolBar->insertSeparator();

	int exitbutton = 0;
	m_pToolBar->insertButton(
		QPixmap("/opt/kde2/share/icons/hicolor/32x32/apps/kcmx.png"),
		exitbutton,
		SIGNAL(clicked()),
		this,
		SLOT(shutdown()),
		true,
		i18n("Exit"));

	m_pToolBar->setIconText(KToolBar::IconTextBottom);
	addToolBar(m_pToolBar);

	m_pToolBar->setItemEnabled(m_DisconnectButton, false);
	m_pToolBar->setItemEnabled(m_RentButton, false);
	m_pToolBar->setItemEnabled(m_ReturnButton, false);
	m_pToolBar->setItemEnabled(m_ReserveButton, false);
	m_pToolBar->setItemEnabled(m_SearchButton, false);
//	m_pToolBar->setItemEnabled(m_AddButton, false);
	
	m_pCentralWidget = new QTabWidget(this);
	m_pLog = new QMultiLineEdit(m_pCentralWidget);
	m_pLog->setReadOnly(true);

	m_pList = new QListView(m_pCentralWidget);
	m_pList->addColumn("Member No.");
	m_pList->addColumn("DVD");
	m_pList->addColumn("Title");
	m_pList->addColumn("Due Back");
	
	m_pCentralWidget->addTab(m_pLog, "DVDStore");
	m_pCentralWidget->addTab(m_pList, "On Loan");

	setView(m_pCentralWidget);

	resize(460, 300);
}


MainWindow::~MainWindow()
{
	QString logfile = SettingsManager::instance()->getString("logfile");
	if(logfile == "")
		logfile = "logfile.txt";

	QFile f(logfile);

	if(f.open(IO_WriteOnly | IO_Raw | IO_Append))
	{
		QTextStream s(&f);
		s << m_pLog->text();
		s << "\n";
		f.close();
	}
}


void
MainWindow::connectDatabase()
{
	ConnectDialog dlg(this);
	int rc = dlg.exec();

	if(rc == 1)
	{
		m_pStoreMenu->setItemEnabled(m_ConnectItem, false);
		m_pStoreMenu->setItemEnabled(m_DisconnectItem, true);
		m_pStoreMenu->setItemEnabled(m_AddMemberItem, true);
		m_pStoreMenu->setItemEnabled(m_NewTitleItem, true);
		m_pStoreMenu->setItemEnabled(m_NewDiskItem, true);
		m_pEditMenu->setItemEnabled(m_FindItem, true);
		m_pEditMenu->setItemEnabled(m_RentItem, true);
		m_pEditMenu->setItemEnabled(m_ReturnItem, true);
		m_pEditMenu->setItemEnabled(m_ReserveItem, true);

		m_pToolBar->setItemEnabled(m_ConnectButton, false);
		m_pToolBar->setItemEnabled(m_DisconnectButton, true);
		m_pToolBar->setItemEnabled(m_RentButton, true);
		m_pToolBar->setItemEnabled(m_ReturnButton, true);
		m_pToolBar->setItemEnabled(m_ReserveButton, true);
		m_pToolBar->setItemEnabled(m_SearchButton, true);
		m_pToolBar->setItemEnabled(m_AddButton, true);
	}
}


void
MainWindow::disconnectDatabase()
{
	dvd_close_db();
	
	m_pStoreMenu->setItemEnabled(m_ConnectItem, true);
	m_pStoreMenu->setItemEnabled(m_DisconnectItem, false);
	m_pStoreMenu->setItemEnabled(m_AddMemberItem, false);
	m_pStoreMenu->setItemEnabled(m_NewTitleItem, false);
	m_pStoreMenu->setItemEnabled(m_NewDiskItem, false);
	m_pEditMenu->setItemEnabled(m_FindItem, false);
	m_pEditMenu->setItemEnabled(m_RentItem, false);
	m_pEditMenu->setItemEnabled(m_ReturnItem, false);
	m_pEditMenu->setItemEnabled(m_ReserveItem, false);

	m_pToolBar->setItemEnabled(m_ConnectButton, true);
	m_pToolBar->setItemEnabled(m_DisconnectButton, false);
	m_pToolBar->setItemEnabled(m_RentButton, false);
	m_pToolBar->setItemEnabled(m_ReturnButton, false);
	m_pToolBar->setItemEnabled(m_ReserveButton, false);
	m_pToolBar->setItemEnabled(m_SearchButton, false);
	m_pToolBar->setItemEnabled(m_AddButton, false);

	addLog("Disconnected from the database");
}


void
MainWindow::addMember()
{
	MemberDialog dlg(this);
	dlg.show();
}


void
MainWindow::addTitle()
{
	TitleDialog dlg(this);
	dlg.show();
}


void
MainWindow::addDisk()
{
	bool ok;
	int title_id = QInputDialog::getInteger(
		"Add Disk",
		"Add a Disk record to Title ID",
		0, 0, 100000, 1, &ok);

	if(ok)
	{
		dvd_disk disk;
		int disk_id;
		dvd_disk_create(&disk, &disk_id);
		QString str;
		str.sprintf("Created Disk ID %d for Title ID %d",
					disk_id, title_id);
		addLog(str);
		QMessageBox::information(this, "DVDstore", str, "Okay");
	}
}


void
MainWindow::find()
{
	SearchDialog dlg(this);
	dlg.show();
}



void
MainWindow::rentDVD()
{
	RentDialog dlg(0, this);
	dlg.show();
}



void
MainWindow::returnDVD()
{
	ReturnDialog dlg(this);
	dlg.show();
}



void
MainWindow::reserve()
{
	ReserveDialog dlg(this);
	dlg.show();
}


void
MainWindow::preferences()
{
	PreferencesDialog dlg(this);
	dlg.show();
}


void
MainWindow::about()
{
	QMessageBox::about(this, "DVDstore",
					   "DVDstore\n"
					   "\n"
					   "Author: Marius Sundbakken <marius@sundbakken.org>\n\n"
					   "A Qt GUI for the DVDstore conceived in\n"
					   "'Professional Linux Programming'\n"
					   "Wrox Press 2000");	
}


void
MainWindow::shutdown()
{
	int rc = QMessageBox::warning(this, "DVDstore",
								  "Are you sure you want to quit?",
								  "Yes", "No");

	if(rc == 0)
	{
		dvd_close_db();
		qApp->quit();
	}
}


void
MainWindow::addLog(
	const QString& msg)
{
	QTime t = QTime::currentTime();
	QDate d = QDate::currentDate();
	QString str;
	str.sprintf("%02d:%02d %02d/%02d/%02d -- %s",
				t.hour(),
				t.minute(),
				d.month(),
				d.day(),
				d.year(),
				(const char *)msg);

	if(m_pLog == 0)
		cout << str << endl;
	else
		m_pLog->insertLine(str);
}

