
#include "dvdsearchpage.h"
#include "rentdialog.h"
#include "settingsmanager.h"
#include "qdvd.h"

#include <stdlib.h>
#include <iostream.h>

#include <qgrid.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlistview.h>
#include <qpopupmenu.h>

DVDSearchPage::DVDSearchPage(
	QWidget *parent,
	const char *name)
	: QWidget(parent, name)
{
	QVBoxLayout *main = new QVBoxLayout(this, 4, 4);
	QHBoxLayout *top = new QHBoxLayout;
	QHBoxLayout *bottom = new QHBoxLayout;

	QGrid *grid = new QGrid(2, this);
	grid->setSpacing(4);
	QLabel *l;
	l = new QLabel("Search for:", grid);
	l->setFixedSize(l->sizeHint());
	m_pSearchFor = new QComboBox(true, grid);
	l =  new QLabel("with Actor/Director:", grid);
	l->setFixedSize(l->sizeHint());
	m_pActor = new QComboBox(true, grid);

	QPushButton *search = new QPushButton("Search", this);
	search->setFixedSize(search->sizeHint());
	connect(search, SIGNAL(clicked()), this, SLOT(search()));
	
	m_pList = new QListView(this);
	m_pList->addColumn("Title ID");
	m_pList->addColumn("Title");

	SettingsManager *sm = SettingsManager::instance();
	
	if(sm->getBool("show_refnum"))
		m_pList->addColumn("Ref No");
	
	if(sm->getBool("show_director"))
		m_pList->addColumn("Director");
	
	if(sm->getBool("show_genre"))
		m_pList->addColumn("Genre");
	
	if(sm->getBool("show_classif"))
		m_pList->addColumn("Classification");

	if(sm->getBool("show_actor1"))
		m_pList->addColumn("Actor 1");
	
	if(sm->getBool("show_actor2"))
		m_pList->addColumn("Actor 2");
	
	if(sm->getBool("show_reldate"))
		m_pList->addColumn("Release Date");
	
	if(sm->getBool("show_rentcost"))
		m_pList->addColumn("Rental Cost");
	
	QPushButton *clear = new QPushButton("Clear", this);
	connect(clear, SIGNAL(clicked()), this, SLOT(clear()));

	bottom->addStretch();
	bottom->addWidget(clear);
	
	top->addWidget(grid);
	top->addWidget(search);
	main->addLayout(top);
	main->addWidget(m_pList);
	main->addLayout(bottom);

	m_pPopup = new QPopupMenu(this);
	m_pPopup->insertItem("Rent...",
					  this,
					  SLOT(rent()));
	m_pPopup->insertItem("Reserve...",
					  this,
					  SLOT(reserve()));
	m_pPopup->insertSeparator();
	m_pPopup->insertItem("Edit...",
					  this,
					  SLOT(edit()));
	m_pPopup->insertItem("Delete",
					  this,
					  SLOT(deleteDvd()));

	connect(m_pList,
			SIGNAL(rightButtonClicked(QListViewItem*, const QPoint&, int)),
			this,
			SLOT(showPopup(QListViewItem*, const QPoint&, int)));
}


DVDSearchPage::~DVDSearchPage()
{
}


void
DVDSearchPage::search()
{
	m_pList->clear();

	int *result;
	int count, colno;
	dvd_title dvd;
	
	dvd_title_search(m_pSearchFor->currentText(),
					 m_pActor->currentText(),
					 &result,
					 &count);

	SettingsManager *sm = SettingsManager::instance();
	QListViewItem *item;
	
	for(int i = 0; i < count; i++)
	{
		dvd_title_get(result[i], &dvd);

		item = new QListViewItem(m_pList);
		item->setText(0, QString::number(dvd.title_id));
		item->setText(1, dvd.title_text);
		colno = 2;
	
		if(sm->getBool("show_refnum"))
			item->setText(colno++, dvd.asin);
		if(sm->getBool("show_director"))
			item->setText(colno++, dvd.director);
		if(sm->getBool("show_genre"))
			item->setText(colno++, dvd.genre);
		if(sm->getBool("show_classif"))
			item->setText(colno++, dvd.classification);
		if(sm->getBool("show_actor1"))
			item->setText(colno++, dvd.actor1);
		if(sm->getBool("show_actor2"))
			item->setText(colno++, dvd.actor2);
		if(sm->getBool("show_reldate"))
			item->setText(colno++, dvd.release_date);
		if(sm->getBool("show_rentcost"))
			item->setText(colno++, dvd.rental_cost);
	}
	
	free(result);
}


void
DVDSearchPage::clear()
{
	m_pList->clear();
}


void
DVDSearchPage::rent()
{
	QListViewItem *item = m_pList->currentItem();
	int title_id = item->text(0).toInt();
	RentDialog dlg(title_id, this);
	dlg.show();
}

void
DVDSearchPage::reserve()
{
}

void
DVDSearchPage::edit()
{
}

void
DVDSearchPage::deleteDvd()
{
}

void
DVDSearchPage::showPopup(QListViewItem *item, const QPoint &p, int)
{
	if(item != 0)
		m_pPopup->popup(p);
}

