
#include "disksearchpage.h"
#include "qdvd.h"

#include <qgrid.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlistview.h>

DiskSearchPage::DiskSearchPage(
	QWidget *parent,
	const char *name)
	: QWidget(parent, name)
{
	QVBoxLayout *main = new QVBoxLayout(this, 4, 4);
	QHBoxLayout *top = new QHBoxLayout;
	QHBoxLayout *bottom = new QHBoxLayout;

	QLabel *l = new QLabel("Search for Disks for Title ID:", this);
	m_pSearchFor = new QSpinBox(this);
	QPushButton *search = new QPushButton("Search", this);
	connect(search, SIGNAL(clicked()), this, SLOT(search()));

	top->addWidget(l);
	top->addWidget(m_pSearchFor);
	top->addWidget(search);
	
	m_pList = new QListView(this);

	m_pList->addColumn("Title ID");
	m_pList->addColumn("Title");
	m_pList->addColumn("Disk ID");
	m_pList->addColumn("On Loan to Member ID");	
	
	QPushButton *clear = new QPushButton("Clear", this);
	connect(clear, SIGNAL(clicked()), this, SLOT(clear()));

	bottom->addStretch();
	bottom->addWidget(clear);
	
	main->addLayout(top);
	main->addWidget(m_pList);
	main->addLayout(bottom);

	main->activate();
}


DiskSearchPage::~DiskSearchPage()
{
}


void
DiskSearchPage::search()
{
	m_pList->clear();

	int title_id = m_pSearchFor->value();
	int *result;
	int count;
	int rc = dvd_disk_search(title_id, &result, &count);

	if(rc == 0)
	{
		dvd_title dvd;
		dvd_title_get(title_id, &dvd);
		QListViewItem *item;
		char date_rented[9];
		int r, member_id;
		
		for(int i = 0; i < count; i++)
		{
			item = new QListViewItem(m_pList);
			item->setText(0, QString::number(title_id));
			item->setText(1, dvd.title_text);
			item->setText(2, QString::number(result[i]));

			r = dvd_rented_disk_info(result[i],
									 &member_id,
									 date_rented);

			if(r == 0)	
				item->setText(3, QString::number(member_id));
		}
	}
	
}


void
DiskSearchPage::clear()
{
	m_pList->clear();
}
