/*
 * A helloworld application using GTK+
 */

#include <gtk/gtk.h>

static void
on_button_clicked(GtkWidget *button, gpointer data)
{
  g_print("The button was clicked - Hello World!\n");
}

static gint
on_delete_event(GtkWidget *window, GdkEventAny *event, gpointer data)
{
  gtk_main_quit();
  return FALSE;
}

gint
main(gint argc, gchar *argv[])
{
  GtkWidget *window;
  GtkWidget *vbox;
  GtkWidget *label;
  GtkWidget *button;

  gtk_init(&argc, &argv);

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  vbox = gtk_vbox_new(TRUE, 10);
  label = gtk_label_new("This label is placed first into the VBox");
  button = gtk_button_new_with_label("Click Me!");

  gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
  gtk_container_add(GTK_CONTAINER(window), vbox);
 
  gtk_window_set_title(GTK_WINDOW(window), "The Title");

  gtk_signal_connect(GTK_OBJECT(window), "delete_event",
               GTK_SIGNAL_FUNC(on_delete_event),
               NULL);

  gtk_signal_connect(GTK_OBJECT(button), "clicked",
               GTK_SIGNAL_FUNC(on_button_clicked),
               NULL);

  gtk_widget_show_all(window);

  gtk_main();

  return 0;

}
