#include <gnome.h>

const static gchar *app_id = "Gnome Example";
const static gchar *version = "0.1";

static void
on_menu_item_clicked(GtkWidget *button, gpointer data)
{
  gchar *text = (gchar*) data;
  g_print("The %s menu item was clicked\n", text);
}

/* File menu structures */
static GnomeUIInfo filemenu[] = {
     GNOMEUIINFO_MENU_NEW_ITEM ( "New", "This is the Hint", on_menu_item_clicked, "New"),
     GNOMEUIINFO_MENU_OPEN_ITEM ( on_menu_item_clicked, "Open" ),
     GNOMEUIINFO_END
     };

static GnomeUIInfo custom_menu[] = {
     {GNOME_APP_UI_ITEM, "Item One", "Item One Hint", NULL, NULL, 0, 0},
     {GNOME_APP_UI_ITEM, "Item Two", "Item Two Hint", NULL, NULL, 0 ,0},
     GNOMEUIINFO_END
     };

static GnomeUIInfo menu[] = {
     GNOMEUIINFO_MENU_FILE_TREE (filemenu),
     GNOMEUIINFO_SUBTREE ("Custom", custom_menu),
     GNOMEUIINFO_END
     };

static gint
on_delete_event(GtkWidget *window, GdkEventAny *event, gpointer data)
{
  gtk_main_quit();
  return FALSE;
}

gint main(gint argc, gchar *argv[])
{
  GtkWidget *window;

  gnome_init(app_id, version, argc, argv);

  window = gnome_app_new (app_id, "This is the window Title");
  gtk_window_set_default_size(GTK_WINDOW(window), 300, 300);

  gtk_signal_connect(GTK_OBJECT(window), "delete_event",
               GTK_SIGNAL_FUNC(on_delete_event),
               NULL);
  gnome_app_create_menus(GNOME_APP(window), menu);
  gnome_app_create_toolbar(GNOME_APP(window), custom_menu);
  gtk_widget_show(window);
  gtk_main();
  return 0;
}
