#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>


#include <lber.h>
#include <ldap.h>

int main( int argc, char *argv[] ) {
  LDAP *ld;
  int res;

  int  authmethod = LDAP_AUTH_SIMPLE;
  
  char *ldap_host = "localhost";

  char *user_dn = "cn=root, o=stixen.co.uk, c=uk";
  char *user_pw = "secret";
  
  char *new_dn = "cn=Jenny Stones, ou=People, o=stixen.co.uk, c=uk";

  char *title_vals[] = {"Supervisor", NULL};
  char *phone_vals[] = {"01234 654310987", NULL};


  LDAPMod title_attribute, telephoneNumber_attribute;

  LDAPMod *mods[3];


  title_attribute.mod_op = LDAP_MOD_REPLACE;
  title_attribute.mod_type = "title";
  title_attribute.mod_values = title_vals;

  telephoneNumber_attribute.mod_op = LDAP_MOD_ADD;
  telephoneNumber_attribute.mod_type = "telephoneNumber";
  telephoneNumber_attribute.mod_values = phone_vals;

  mods[0] = &title_attribute;
  mods[1] = &telephoneNumber_attribute;
  mods[2] = NULL;


  if ((ld = ldap_init(ldap_host, LDAP_PORT)) == NULL ) {
    perror( "Failure of ldap_init" );
    exit( EXIT_FAILURE );
  }

  if (ldap_bind_s(ld, user_dn, user_pw, authmethod) != LDAP_SUCCESS ) {
    ldap_perror( ld, "Failure of ldap_bind" );
    exit( EXIT_FAILURE );
  }
  
  if (ldap_modify_s(ld, new_dn, mods) != LDAP_SUCCESS) {
    ldap_perror( ld, "Failure of ldap_modify_s" );
  }
  
  res = ldap_unbind_s(ld);
  if (res != 0) {
    fprintf(stderr, "ldap_unbind_s failed: %s\n", ldap_err2string(res));
    exit( EXIT_FAILURE );
  }

  return EXIT_SUCCESS;
} /* main */









