#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>


#include <lber.h>
#include <ldap.h>

int main( int argc, char *argv[] ) {
  LDAP *ld;
  int res;

  int  authmethod = LDAP_AUTH_SIMPLE;
  
  char *ldap_host = "localhost";

  char *user_dn = "cn=root, o=stixen.co.uk, c=uk";
  char *user_pw = "secret";
  
  char *new_dn = "cn=Jenny Stones, ou=People, o=stixen.co.uk, c=uk";

  char *cn_vals[] = {"Jenny Stones", NULL};
  char *sn_vals[] = {"Stones", NULL};
  char *givenname_vals[] = {"Jenny", NULL};
  char *uid_vals[] = {"stonesj", NULL};
  char *title_vals[] = {"Programmer", NULL};
  char *objectClass_vals[] = {"top", "person", NULL};
  char *ou_vals[] = {"Development", "People", NULL};

  LDAPMod cn_attribute, sn_attribute, givenname_attribute, uid_attribute, title_attribute, objectClass_attribute, ou_attribute;

  LDAPMod *mods[8];

  cn_attribute.mod_op = LDAP_MOD_ADD;
  cn_attribute.mod_type = "cn";
  cn_attribute.mod_values = cn_vals;

  sn_attribute.mod_op = LDAP_MOD_ADD;
  sn_attribute.mod_type = "sn";
  sn_attribute.mod_values = sn_vals;

  givenname_attribute.mod_op = LDAP_MOD_ADD;
  givenname_attribute.mod_type = "givenname";
  givenname_attribute.mod_values = givenname_vals;

  uid_attribute.mod_op = LDAP_MOD_ADD;
  uid_attribute.mod_type = "uid";
  uid_attribute.mod_values = uid_vals;

  title_attribute.mod_op = LDAP_MOD_ADD;
  title_attribute.mod_type = "title";
  title_attribute.mod_values = title_vals;

  objectClass_attribute.mod_op = LDAP_MOD_ADD;
  objectClass_attribute.mod_type = "objectClass";
  objectClass_attribute.mod_values = objectClass_vals;

  ou_attribute.mod_op = LDAP_MOD_ADD;
  ou_attribute.mod_type = "ou";
  ou_attribute.mod_values = ou_vals;

  mods[0] = &cn_attribute;
  mods[1] = &sn_attribute;
  mods[2] = &givenname_attribute;
  mods[3] = &uid_attribute;
  mods[4] = &title_attribute;
  mods[5] = &objectClass_attribute;
  mods[6] = &ou_attribute;
  mods[7] = NULL;


  if ((ld = ldap_init(ldap_host, LDAP_PORT)) == NULL ) {
    perror( "Failure of ldap_init" );
    exit( EXIT_FAILURE );
  }

  if (ldap_bind_s(ld, user_dn, user_pw, authmethod) != LDAP_SUCCESS ) {
    ldap_perror( ld, "Failure of ldap_bind" );
    exit( EXIT_FAILURE );
  }
  
  if (ldap_add_s(ld, new_dn, mods) != LDAP_SUCCESS) {
    ldap_perror( ld, "Failure of ldap_add_s" );
  }
  
  res = ldap_unbind_s(ld);
  if (res != 0) {
    fprintf(stderr, "ldap_unbind_s failed: %s\n", ldap_err2string(res));
    exit( EXIT_FAILURE );
  }

  return EXIT_SUCCESS;
} /* main */









