#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <lber.h>
#include <ldap.h>

int main( int argc, char *argv[] ) {
  LDAP *ld;
  int res;

  int  authmethod = LDAP_AUTH_SIMPLE;
  
  char *ldap_host = "localhost";

  char *user_dn = "cn=root, o=stixen.co.uk, c=uk";
  char *user_pw = "secret";

  if ((ld = ldap_init(ldap_host, LDAP_PORT)) == NULL ) {
    perror( "Failure of ldap_init" );
    exit( EXIT_FAILURE );
  }

  if (ldap_bind_s(ld, user_dn, user_pw, authmethod) != LDAP_SUCCESS ) {
    ldap_perror( ld, "Failure of ldap_bind" );
    exit( EXIT_FAILURE );
  }
  

  res = ldap_unbind_s(ld);
  if (res != 0) {
    fprintf(stderr, "ldap_unbind_s failed: %s\n", ldap_err2string(res));
    exit( EXIT_FAILURE );
  }

  return EXIT_SUCCESS;
} /* main */








