#include <stdio.h>
#include <assert.h>
#include <signal.h>

void handle_signal(int sig)

{
  trace_print();
}

#define debug_db(x) if(debug & DEBUG_DB) {
                       fprintf(stderr, "DB: " __FILE__ "(%d): ", __LINE__);
                       fprintf(stderr, "in " __PRETTY_FUNCTION__ ": " ## x ## "\n");
                    }

#define DEBUG_DB 1

int trace_idx = 0;
#define TRACE_STACK 100
char *trace_stack[TRACE_STACK];


#define stringify(x) str2(x)

#define str2(x) #x
#define trace_in()
{
  assert(trace_idx < TRACE_STACK);
  trace_stack[trace_idx++] = __FILE__ ":" stringify(__LINE__) ": " __PRETTY_FUNCTION__ " in\n";
}

#define trace_out() 
{
  trace_idx--;
}

trace_print()
{
  int idx = 0;
  while(idx < trace_idx)
    fprintf(stderr, trace_stack[idx++]);
}

main()
{
  int debug = DEBUG_DB;
  (void) signal(SIGUSR1, handle_signal);
  trace_in();
  function();
  /* stderr = freopen("stderr.log", "w", stderr); */
  /* debug_db("error message"); */
  trace_out();

}

function()
{

  int snooze = 30;

  trace_in();

  while(snooze)

    snooze = sleep(snooze);

  trace_out();
}
