/* backtrace.c */

#include <stdio.h>
#include <execinfo.h>

/*
 Przykladowy program dla zilustrowania uzycia backtrace
*/

void dumptrace()
{
#define maxdepth 10
  static void *addresses[maxdepth];
  int naddresses = backtrace(addresses, maxdepth);
  char **names = backtrace_symbols(addresses, naddresses);
  int i = 0;
  for(i; i < naddresses; i++)
    fprintf(stderr, "%d: %s\n", i, names[i]);
  free(names);
}

func3()
{
  dumptrace();
}

func2()
{
  func3();
}

func1()
{
  func2();
}

int main()
{
  func1();
}
