
#include <stdlib.h>
#include <stdio.h>

#include <parser.h>
#include <parserInternals.h>

static void start_document(void *ctx);
static void end_document(void *ctx);


static xmlSAXHandler mySAXParseCallbacks;

int main() {

  xmlParserCtxtPtr ctxt_ptr;

  memset(&mySAXParseCallbacks, sizeof(mySAXParseCallbacks), 0);
  mySAXParseCallbacks.startDocument = start_document;
  mySAXParseCallbacks.endDocument = end_document;

  ctxt_ptr = xmlCreateFileParserCtxt("dvdcatalog.xml");
  if (!ctxt_ptr) {
    fprintf(stderr, "Failed to create file parser\n");
    exit(EXIT_FAILURE);
  }

  ctxt_ptr->sax = &mySAXParseCallbacks;

  xmlParseDocument(ctxt_ptr);


  ctxt_ptr->sax = NULL;

  xmlFreeParserCtxt(ctxt_ptr);

  printf("Parsing complete\n");
  exit(EXIT_SUCCESS);
}

static void start_document(void *ctx) {
  printf("Document start\n");
}

static void end_document(void *ctx) {
  printf("Document end\n");
}


