
#include <stdlib.h>
#include <stdio.h>

#include <parser.h>
#include <parserInternals.h>


int main() {

  xmlParserCtxtPtr ctxt_ptr;

  ctxt_ptr = xmlCreateFileParserCtxt("dvdcatalog.xml");
  if (!ctxt_ptr) {
    fprintf(stderr, "Failed to create file parser\n");
    exit(EXIT_FAILURE);
  }

  xmlParseDocument(ctxt_ptr);

  if (!ctxt_ptr->wellFormed) {
    fprintf(stderr, "Document not well formed\n");
  }
  printf("XML version %s, encoding %s\n", ctxt_ptr->version, ctxt_ptr->encoding);


  ctxt_ptr->sax = NULL;

  xmlFreeParserCtxt(ctxt_ptr);

  printf("Parsing complete\n");
  exit(EXIT_SUCCESS);
}




