/*
 *  Contains Gnome/GTK+ gui functions for DVD store
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "interface.h"
#include "support.h"
#include "dvd.h"
#include "misc.h"
#include "dvd_gui.h"
#include "title_dialog.h"

void
do_dvd_dialog(gint title_id_to_edit)
{
  static GtkWidget* dvd_dialog = NULL;
  GtkWidget *genre;
  GtkWidget *classification;
  gchar **genres;
  gchar **classifications;
  time_t the_date;
  struct tm *date = NULL;
  gint year, month, day;
  gint ngenres;
  gint nclasses;
  dvd_title title;

  GList *items = NULL;

  if (dvd_dialog != NULL)
    { 
      /* Try to raise and de-iconify dialog
       */
      gdk_window_show(dvd_dialog->window);
      gdk_window_raise(dvd_dialog->window);
    }
  else
    {
      /* Call the glade created function to create
       * the dialog and connect callbacks
       */
      dvd_dialog = create_dvd_dialog ();
      gtk_signal_connect(GTK_OBJECT(dvd_dialog),
			 "destroy",
			 GTK_SIGNAL_FUNC(gtk_widget_destroyed),
			 &dvd_dialog);   
      gnome_dialog_set_parent(GNOME_DIALOG(dvd_dialog),
			      GTK_WINDOW(main_window));
      gnome_dialog_set_close(GNOME_DIALOG(dvd_dialog),
			     TRUE);
      genre = lookup_widget(dvd_dialog, "genre");
      classification = lookup_widget(dvd_dialog, "classification");

      /* 
       * Set the contents of the genre and classification combo boxes
       */
      dvd_gui_show_result("get_genres", dvd_get_genre_list(&genres, &ngenres));
      while (ngenres>0){
	items = g_list_append(items, genres[--ngenres]);
      }
      gtk_combo_set_popdown_strings (GTK_COMBO (genre), items);
      gtk_combo_set_value_in_list (GTK_COMBO (genre), TRUE, TRUE);

      items = NULL;

      dvd_gui_show_result("get_classification", 
			  dvd_get_classification_list(&classifications, &nclasses));
      while (nclasses>0){
	items = g_list_append(items, classifications[--nclasses]);
      }
      gtk_combo_set_popdown_strings (GTK_COMBO (classification), items);
      gtk_combo_set_value_in_list (GTK_COMBO (classification), TRUE, TRUE);
      g_list_free(items);

      if (dvd_title_get(title_id_to_edit, &title) == DVD_SUCCESS)
	{
	  gtk_label_set_text(GTK_LABEL(lookup_widget(dvd_dialog, "title_id")), 
			     g_strdup_printf("%d", title.title_id));
	  gtk_entry_set_text(GTK_ENTRY(lookup_widget(dvd_dialog, "title")), title.title_text);
	  gtk_entry_set_text(GTK_ENTRY(lookup_widget(dvd_dialog, "ref")), title.asin);
	  gtk_entry_set_text(GTK_ENTRY(lookup_widget(dvd_dialog, "director")), title.director);
	  gtk_entry_set_text(GTK_ENTRY(lookup_widget(dvd_dialog, "genre_entry")), title.genre);
	  gtk_entry_set_text(GTK_ENTRY(lookup_widget(dvd_dialog, "class_entry")), title.classification);
	  gtk_entry_set_text(GTK_ENTRY(lookup_widget(dvd_dialog, "actor_1")), title.actor1);
	  gtk_entry_set_text(GTK_ENTRY(lookup_widget(dvd_dialog, "actor_2")), title.actor2);
	  sscanf(title.release_date, "%04d%02d%02d", &year, &month, &day);
	  the_date = time(NULL);
	  date = localtime(&the_date);
	  date -> tm_year = year - 1900;
	  date -> tm_mon = month - 1;
	  date -> tm_mday = day;
	  the_date = mktime(date); 
	  gnome_date_edit_set_time(GNOME_DATE_EDIT(lookup_widget(dvd_dialog, "release_date")),
				   the_date);
	  gtk_spin_button_set_value(GTK_SPIN_BUTTON(lookup_widget(dvd_dialog, "rental_cost")),
				    (gfloat) atof(title.rental_cost));

	  gtk_window_set_title(GTK_WINDOW(dvd_dialog), _("Edit Title"));
	}
        gtk_widget_show (dvd_dialog);
    }
} 

void
on_dvd_dialog_clicked                  (GnomeDialog     *gnomedialog,
                                        gint             arg1,
                                        gpointer         user_data)
{
  GtkWidget *b;
  gchar *title_id_char;
  time_t the_date;
  struct tm *date;
  gchar *msg;
  gint title_id = 0;
  gfloat cost;
  dvd_title new_title;
  dvd_title title_check;

  if (arg1 == GNOME_OK)
    {
      b = GTK_WIDGET(gnomedialog);

      strcpy((new_title.title_text), 
	     gtk_entry_get_text(GTK_ENTRY(lookup_widget(b, "title"))));
      strcpy((new_title.asin), 
	     gtk_entry_get_text(GTK_ENTRY(lookup_widget(b, "ref"))));
      strcpy((new_title.director), 
	     gtk_entry_get_text(GTK_ENTRY(lookup_widget(b, "director"))));
      strcpy((new_title.genre), 
	     gtk_entry_get_text(GTK_ENTRY(lookup_widget(b, "genre_entry"))));
      strcpy((new_title.classification), 
	     gtk_entry_get_text(GTK_ENTRY(lookup_widget(b, "class_entry"))));
      strcpy((new_title.actor1), 
	     gtk_entry_get_text(GTK_ENTRY(lookup_widget(b, "actor_1"))));
      strcpy((new_title.actor2), 
	     gtk_entry_get_text(GTK_ENTRY(lookup_widget(b, "actor_2"))));
      the_date = gnome_date_edit_get_date(GNOME_DATE_EDIT(lookup_widget(b, "release_date")));
      date = gmtime(&the_date);
      sprintf(new_title.release_date, "%04d%02d%02d",
	      date -> tm_year + 1900,
	      date -> tm_mon + 1,
	      date -> tm_mday);

      cost = gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(lookup_widget(b, "rental_cost")));
      strcpy((new_title.rental_cost), g_strdup_printf("%f", cost));
      
      gtk_label_get(GTK_LABEL(lookup_widget(b, "title_id")), &title_id_char);
      title_id = atoi(title_id_char);
      
      if (dvd_title_get(title_id, &title_check) == DVD_SUCCESS)
	{
	  new_title.title_id = title_id;
	  dvd_gui_show_result("title_set", dvd_title_set(&new_title));
	}
      else
	{
	  dvd_gui_show_result("title_create", dvd_title_create(&new_title, &title_id));
	  dvd_gui_show_result("title_get", dvd_title_get(title_id, &new_title));
	  msg = g_strdup_printf(_("Added Title '%s' : Title ID %d"), new_title.title_text, title_id);
	  add_log_message(msg);
	  g_free(msg);
	}
    }
}








