/*
 *  Contains Gnome/GTK+ gui functions for DVD store
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "interface.h"
#include "support.h"
#include "dvd.h"
#include "misc.h"
#include "dvd_gui.h"
#include "return_dialog.h"

static GSList *return_disk_slist;

void
do_return_dvd_dialog()
{
  static GtkWidget *return_dvd_dialog = NULL;

  g_slist_free(return_disk_slist);
  return_disk_slist = NULL;

  if (return_dvd_dialog != NULL)
    {
      gdk_window_show(return_dvd_dialog->window);
      gdk_window_raise(return_dvd_dialog->window);
    }
  else
    {
      return_dvd_dialog = create_return_dvd_dialog();
      g_slist_free(return_disk_slist);
      gtk_signal_connect(GTK_OBJECT(return_dvd_dialog),
			 "destroy",
			 GTK_SIGNAL_FUNC(gtk_widget_destroyed), 
			 &return_dvd_dialog);

      gnome_dialog_set_close(GNOME_DIALOG(return_dvd_dialog),
			     TRUE);
      gnome_dialog_set_parent(GNOME_DIALOG(return_dvd_dialog),
			      GTK_WINDOW(main_window));
      gtk_widget_show(return_dvd_dialog);
    }
}

void
on_return_dvd_dialog_clicked           (GnomeDialog     *gnomedialog,
                                        gint             arg1,
                                        gpointer         user_data)
{
  gint count;
  gint diskid;
  gint memberid;
  gchar *date;
  gchar *msg;

  if (arg1 == GNOME_OK)
    { 
      date = g_malloc(9);

      count = g_slist_length(return_disk_slist);
      while (count--) 
	{
	  diskid = GPOINTER_TO_INT(g_slist_nth_data(return_disk_slist,
						    count));    
	  
	  dvd_gui_show_result("dvd_disk_return", dvd_disk_return(diskid, &memberid, date));
	  msg = g_strdup_printf(_("Returned Disk: %d"), diskid);
	  add_log_message(msg);
	  g_free(msg);
	}
      g_free(date);
    }
}

void
on_return_dvd_dialog_add_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList *disk_clist;
  GtkWidget *diskid_spinbutton;
  gint diskid;
  gint memberid;
  gchar *date;

  date = g_malloc(9);

  disk_clist = GTK_CLIST(lookup_widget(GTK_WIDGET(button), 
				       "return_dvd_dialog_disk_clist"));
  diskid_spinbutton =  lookup_widget(GTK_WIDGET(button), 
				     "diskid_spinbutton");
  diskid = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(diskid_spinbutton)); 
  

  if (dvd_rented_disk_info(diskid, &memberid, date) == DVD_SUCCESS)
    {
      return_disk_slist = g_slist_append(return_disk_slist, 
					      GINT_TO_POINTER(diskid));
      update_return_dvd_diskid_clist(disk_clist);
    }
  g_free(date);
}


void
on_return_dvd_dialog_remove_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList *disk_clist;
  gint selected_row;
  gint titleid;

  disk_clist = GTK_CLIST(lookup_widget(GTK_WIDGET(button), "return_dvd_dialog_disk_clist"));
  selected_row =  GPOINTER_TO_INT(gtk_clist_get_row_data(disk_clist, 0));
  titleid = GPOINTER_TO_INT(g_slist_nth_data(return_disk_slist,
					     selected_row));
  return_disk_slist = g_slist_remove(return_disk_slist, GINT_TO_POINTER(titleid));
  update_return_dvd_diskid_clist(disk_clist);
}


void
on_return_dvd_dialog_disk_clist_select_row
                                        (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  g_return_if_fail(clist != NULL);
  gtk_clist_set_row_data(clist, 0, GINT_TO_POINTER(row));
}


void
update_return_dvd_diskid_clist(GtkCList *disk_clist)

{
 gchar *text[4];
 dvd_disk disk;
 dvd_title title;
 dvd_store_member member;
 gint diskid;
 gint memberid;
 gchar *date_rented;
 gint result;
 gint count;

 date_rented = g_malloc(9);

 count = g_slist_length(return_disk_slist);
 gtk_clist_clear(disk_clist);

 while (count--) {
   diskid = GPOINTER_TO_INT (g_slist_nth_data(return_disk_slist, count));
   dvd_disk_get(diskid, &disk);

   dvd_gui_show_result("dvd_rented_disk_info", dvd_rented_disk_info(diskid, 
								    &memberid,
								    date_rented));

   dvd_gui_show_result("dvd_member_get", dvd_member_get(memberid, &member));
   result = dvd_title_get(disk.title_id, &title); 

   if (result == DVD_SUCCESS) 
     {
        text[0] = g_strdup_printf("%d", diskid);
	text[1] = title.title_text; 
	text[2] = member.member_no;
     
	if (date_overdue(date_rented) < 0 )
	  text[3] = _("OVERDUE");
	else
	  text[3] = _("Ok");
	
	gtk_clist_prepend(disk_clist, text); 
     }  
 }
 g_free(date_rented);
}








