/*
 *  Contains Gnome/GTK+ gui functions for DVD store
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "interface.h"
#include "support.h"
#include "dvd.h"
#include "misc.h"
#include "dvd_gui.h"
#include "reserve_dialog.h"


void
do_reserve_dialog(gchar *default_member,
		  gint default_title)

{
 
  GtkSpinButton *title_id;
  GtkWidget *member_no;
  static GtkWidget* reserve_dialog = NULL;

  if (reserve_dialog != NULL)
    { 
      /* Try to raise and de-iconify dialog
       */
      gdk_window_show(reserve_dialog->window);
      gdk_window_raise(reserve_dialog->window);
    }
  else
    {
      /* Call the glade created function to create
       * the dialog and connect callbacks
       */
      reserve_dialog = create_reserve_dialog ();

      title_id = GTK_SPIN_BUTTON(lookup_widget(reserve_dialog, 
					       "titleid_spinbutton"));
      member_no = lookup_widget(reserve_dialog, "member_no_entry");

      if (default_title)
	gtk_spin_button_set_value(title_id, (float) default_title);
      
      if (default_member != NULL)
	gtk_entry_set_text(GTK_ENTRY(member_no), default_member);

      gtk_signal_connect(GTK_OBJECT(reserve_dialog),
			 "destroy",
			 GTK_SIGNAL_FUNC(gtk_widget_destroyed),
			 &reserve_dialog);
      gnome_dialog_set_parent(GNOME_DIALOG(reserve_dialog),
			      GTK_WINDOW(main_window));
      gnome_dialog_set_close(GNOME_DIALOG(reserve_dialog),
			     TRUE);
      gtk_widget_show (reserve_dialog);
    }
}


void
on_reserve_dialog_clicked              (GnomeDialog     *gnomedialog,
                                        gint             arg1,
                                        gpointer         user_data)
{
 GtkWidget *titleid_spinbutton;
  gchar *member_no;
  gint member_id;
  gint title_id;
  gint result;
  gchar reserve_date[9];
  gchar *msg;
  time_t the_date;
  struct tm *date;

  if (arg1 == GNOME_OK)
    {
      titleid_spinbutton =  lookup_widget(GTK_WIDGET(gnomedialog), 
					  "titleid_spinbutton");
      title_id = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(titleid_spinbutton)); 
      member_no = gtk_entry_get_text(GTK_ENTRY(lookup_widget(GTK_WIDGET(gnomedialog), 
							     "member_no_entry")));
  
      the_date = gnome_date_edit_get_date(GNOME_DATE_EDIT(lookup_widget(GTK_WIDGET(gnomedialog), 
									"date")));
      date = gmtime(&the_date);
      strcpy((reserve_date), g_strdup_printf("%04d%02d%02d",
					     date -> tm_year + 1900,
					     date -> tm_mon + 1,
					     date -> tm_mday));
      dvd_gui_show_result("get_id_from_number", 
			  dvd_member_get_id_from_number(member_no, &member_id));
      result = dvd_reserve_title(reserve_date, title_id, member_id);
      if (result != DVD_SUCCESS)
	{ 
	  dvd_gui_show_result("dvd_reserve_title", result);
	  return;
	}
      msg = g_strdup_printf(_("Reserved Title %d for member no. %s on %s"), 
			    title_id, member_no, reserve_date); 
      add_log_message(msg);
      g_free(msg);
    }     
}










