/*
 *  properties.c
 *  This file contains code that handles the properies 
 *  dialog box.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "interface.h"
#include "support.h"
#include "dvd.h"
#include "misc.h"
#include "dvd_gui.h"
#include "properties.h"


void
do_property_box()
{
  GtkWidget *property_box;
  gchar *togglebuttons[]= {"ref", "director", "genre", "classification", "actor1", 
			   "actor2", "date", "cost", "title", "fname", "lname", 
			   "houseno", "address1", "address2", "town", "state", 
			   "phone", "zipcode"};
  gint elements = sizeof togglebuttons/sizeof togglebuttons[0];
  gboolean visible;
  gint i;
  
  property_box = create_preferences();
  gnome_config_push_prefix("/dvdstore/search_window/view_field_");
	
  for (i = 0; i < elements; i++)
   {
     visible = gnome_config_get_bool(togglebuttons[i]);
       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(GTK_WIDGET(property_box), 
								    togglebuttons[i]) ),
				    visible);
       gnome_config_set_bool(togglebuttons[i], visible); 
   }
  gnome_config_pop_prefix();

  gtk_entry_set_text(GTK_ENTRY(lookup_widget(GTK_WIDGET(property_box),
					     "logfile_name")),
		     gnome_config_get_string_with_default("/dvdstore/general/logfile_name=logfile.txt", 
							  NULL));

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(lookup_widget(GTK_WIDGET(property_box),
							  "days_rent")),
			    (gfloat) gnome_config_get_int_with_default("/dvdstore/general/days_rent=3", 
								       NULL));
  
  gtk_widget_show(property_box);
}

void
update_search_window_preferences()
{
  GtkCList *title_clist;
  GtkCList *member_clist;
  gboolean visible;
  gint i;
  gint elements;
  gchar *title_field[]= {"ref", "director", "genre", "classification", "actor1", 
			 "actor2", "date", "cost"}; 
  gchar *member_field[] = {"title", "fname", "lname", "houseno", "address1", 
			   "address2", "town", "state", "phone", "zipcode"};

if (search_window == NULL)
    return;

 title_clist = GTK_CLIST(lookup_widget(search_window, "title_search_clist"));
 member_clist = GTK_CLIST(lookup_widget(search_window, "member_search_clist"));

 gnome_config_push_prefix("/dvdstore/search_window/view_field_");

 elements = sizeof title_field/sizeof title_field[0];
 for (i = 0; i < elements; i++)
   {
     visible = gnome_config_get_bool ( g_strconcat(title_field[i], "=TRUE", NULL));
     gtk_clist_set_column_visibility ( title_clist, i+2, visible );
   }

 elements = sizeof member_field/sizeof member_field[0];
 for (i = 0; i < elements; i++)
   {
     visible = gnome_config_get_bool ( g_strconcat(member_field[i], "=TRUE", NULL));
     gtk_clist_set_column_visibility ( member_clist, i+1, visible );
   }
}


void
on_preferences_item_changed            (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GnomePropertyBox *box;

  box = GNOME_PROPERTY_BOX(lookup_widget(GTK_WIDGET(togglebutton), "preferences"));
  gnome_property_box_changed(box);
}


void
on_preferences_apply                   (GnomePropertyBox *pbox,
                                        gint             pagenum,
                                        gpointer         user_data)
{
  gchar *togglebuttons[]= {"ref", "director", "genre", "classification", "actor1", "actor2", 
			   "date", "cost", "title", "fname", "lname", "houseno", "address1", 
			   "address2", "town", "state", "phone", "zipcode"};
  gboolean visible;
  gint elements;
  gint i = 0;

 if (pagenum != -1)
    return;

  gnome_config_push_prefix("/dvdstore/search_window/view_field_");
	
  elements = sizeof togglebuttons/sizeof togglebuttons[0];

  for (i = 0; i < elements; i++)
   {
     visible = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(GTK_WIDGET(pbox), 
									    togglebuttons[i])));
     gnome_config_set_bool(togglebuttons[i], visible); 
   }
  gnome_config_pop_prefix();
  gnome_config_set_int("/dvdstore/general/days_rent", 
		       gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(lookup_widget(GTK_WIDGET(pbox), 
										      "days_rent"))));
 
  gnome_config_set_string("/dvdstore/general/logfile_name",
			  gtk_entry_get_text(GTK_ENTRY(lookup_widget(GTK_WIDGET(pbox), 
								     "logfile_name"))));
  gnome_config_sync();
  update_search_window_preferences();
}









