/*
 *  Contains miscellaneous Gnome/GTK+ gui functions for the DVD store
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <stdio.h>
#include <errno.h>

#include "interface.h"
#include "support.h"
#include "dvd.h"
#include "misc.h"
#include "dvd_gui.h"

static FILE *logfile;
static gboolean connected = FALSE; 

void
dvd_store_connect()
{
  GtkWidget *login_dialog;
  GtkWidget *gtk_username_entry;
  gchar *msg;
  gint reply;
  gint result;

  if (!user)
    {
      login_dialog = create_login_dialog();
      gnome_dialog_set_default(GNOME_DIALOG(login_dialog), GNOME_OK);
      gnome_dialog_editable_enters(GNOME_DIALOG(login_dialog),
				   GTK_EDITABLE(lookup_widget(login_dialog,
							      "password")));
      reply = gnome_dialog_run(GNOME_DIALOG(login_dialog));
      if (reply != GNOME_OK)
	{   
	  gtk_widget_destroy(login_dialog);
	  return;
	}
      
      gtk_username_entry = 
	gnome_entry_gtk_entry(GNOME_ENTRY(lookup_widget(login_dialog,
							"username")));
      user = g_strdup(gtk_entry_get_text(GTK_ENTRY(gtk_username_entry)));
      
      passwd = g_strdup(gtk_entry_get_text(GTK_ENTRY(lookup_widget(login_dialog,
								   "password"))));
      gtk_widget_destroy(login_dialog);
    }
  result = dvd_open_db();
  dvd_gui_show_result("open_db", result);
  if (result == DVD_SUCCESS)
    {
      connected = TRUE;
      sensitize_widgets();
      gnome_appbar_push(GNOME_APPBAR(lookup_widget (main_window, 
						    "appbar1")),
			_("Connected"));
      msg = g_strdup_printf(_("User %s connected to the database"), user);
      add_log_message(msg);
      g_free(msg);
    }
  else
    {
       user = NULL;
       passwd = NULL;
    }
}

void
dvd_store_disconnect()
{
  g_return_if_fail(connected);

  dvd_gui_show_result("close_db", dvd_close_db());
  connected = FALSE;
  sensitize_widgets();
  gnome_appbar_push(GNOME_APPBAR(lookup_widget (main_window, 
						"appbar1")),
		    _("Not Connected"));
  user = NULL;
  passwd = NULL;
  add_log_message(_("Disconnected from the database"));
}

void
sensitize_widgets()
{
  static gboolean sensitive = FALSE;

  gint i;
  gchar *widgets_to_set[] = {"menu_disconnect",
			     "add_member",
			     "new_title",
			     "new_disk",
			     "menu_search",
			     "rent_dvd",
			     "return_dvd",
			     "reserve",
			     "disconnect_button",
			     "rent_button",
			     "return_button",
			     "add_member_button",
			     "search_button",
			     "reserve_button"};
	 
  i = sizeof widgets_to_set/sizeof widgets_to_set[0];
  while (i--) 
    {
      gtk_widget_set_sensitive (GTK_WIDGET(lookup_widget(main_window, widgets_to_set[i])),
				sensitive);
    }
  gtk_widget_set_sensitive (GTK_WIDGET(lookup_widget(main_window,
						     "connect_button")),
			    !sensitive);
  gtk_widget_set_sensitive (GTK_WIDGET(lookup_widget(main_window,
						     "menu_connect")),
			    !sensitive);
  sensitive = !sensitive;
}						     

gboolean
exit_dvdstore(void)

{
  GtkWidget *dialog;
  gint reply;
  
  dialog = gnome_message_box_new(_("Are you sure you want to quit?"),
				     GNOME_MESSAGE_BOX_QUESTION,
				     GNOME_STOCK_BUTTON_YES,
				     GNOME_STOCK_BUTTON_NO,
				     NULL);
  reply = gnome_dialog_run(GNOME_DIALOG(dialog));
  if (reply != GNOME_OK)
    return TRUE;
    
  if (connected) 
    dvd_store_disconnect();
  
  gtk_main_quit ();
  return FALSE;
}

void
open_log_file(void)
{
  if ((logfile = fopen(gnome_config_get_string_with_default("/dvdstore/general/logfile_name=logfile.txt",
							    NULL)
		       ,"a")) == NULL) 
    {
      /* gui_error */
    }
}


void
add_log_message(gchar *msg)
{
  GtkText *textbox;
  gchar *text;
  gchar time_text[50];
  struct tm *time_now = NULL;
  time_t the_time;

  textbox = GTK_TEXT(lookup_widget(main_window, "text_box"));
  
  the_time = time(NULL);
  time_now = localtime(&the_time);
  strftime(time_text, sizeof(time_text), "%R %x", time_now);
 
  text = g_strdup_printf("%s -- %s\n", time_text, msg);
  gtk_text_insert(textbox, NULL, NULL, NULL, text, -1);
  if (logfile != NULL)
    fprintf(logfile, "%s -- %s\n", time_text, msg);
}

void
dvd_gui_show_result(char *msg, int err)
{
  char *err_msg;
 (void) dvd_err_text(err, &err_msg);
  g_print("%s: %s\n", msg, err_msg);
}

gint
date_overdue(gchar *date)
{
  gchar *date_today;
  gint day, month, year;
  gint overdue;
  GDate *g_rent_date;
  GDate *g_date_today;
 
  dvd_today(&date_today);
  sscanf(date_today, "%04d%02d%02d", &year, &month, &day);
  g_date_today = g_date_new_dmy(day, month, year);

  sscanf(date, "%04d%02d%02d", &year, &month, &day);
  g_rent_date = g_date_new_dmy(day, month, year);

  g_date_add_days(g_rent_date, 
		  gnome_config_get_int_with_default("/dvdstore/general/days_rent=3", NULL));
 
 /* 0 for equal, less than zero if g_rent_date is less than g_date_today, greater than zero 
   *  if g_rent_date is greater than g_date_today
   */
  overdue = g_date_compare(g_rent_date, g_date_today);
  g_date_free(g_rent_date);
  g_date_free(g_date_today);
  return overdue;
}


void
do_about_dialog()
{
  GtkWidget* about_dialog = NULL;
   
  /* Call the glade created function to create
   * the dialog and connect callbacks
   */
  about_dialog = create_about_dialog ();
  gtk_widget_show (about_dialog);
} 
















