/*
 *  member_dialog.c
 *  Contains code to handle adding and editing members
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "interface.h"
#include "support.h"
#include "dvd.h"
#include "misc.h"
#include "dvd_gui.h"
#include "member_dialog.h"


void
do_member_dialog(gint member_id_to_edit)
{
  dvd_store_member member;
  
  static GtkWidget* member_dialog = NULL;
  if (member_dialog != NULL)
    { 
      /* Try to raise and de-iconify dialog
       */
      gdk_window_show(member_dialog->window);
      gdk_window_raise(member_dialog->window);
    }
  else
    {
      /* Call the glade created function to create
       * the dialog and connect callbacks
       */
      member_dialog = create_member_dialog ();

      gtk_signal_connect(GTK_OBJECT(member_dialog),
			 "destroy",
			 GTK_SIGNAL_FUNC(gtk_widget_destroyed),
			 &member_dialog);
      gnome_dialog_set_parent(GNOME_DIALOG(member_dialog),
			      GTK_WINDOW(main_window));
      gnome_dialog_set_close(GNOME_DIALOG(member_dialog),
			     TRUE);
      if (dvd_member_get(member_id_to_edit, &member) == DVD_SUCCESS)
	{
	  gtk_label_set_text(GTK_LABEL(lookup_widget(member_dialog, "member_no")), member.member_no);
	  gtk_entry_set_text(GTK_ENTRY(lookup_widget(member_dialog, "title")), member.title);
	  gtk_entry_set_text(GTK_ENTRY(lookup_widget(member_dialog, "first_name")), member.fname);
	  gtk_entry_set_text(GTK_ENTRY(lookup_widget(member_dialog, "last_name")), member.lname);
	  gtk_entry_set_text(GTK_ENTRY(lookup_widget(member_dialog, "house_flat_ref")), member.house_flat_ref);
	  gtk_entry_set_text(GTK_ENTRY(lookup_widget(member_dialog, "address_1")), member.address1);
	  gtk_entry_set_text(GTK_ENTRY(lookup_widget(member_dialog, "address_2")), member.address2);
	  gtk_entry_set_text(GTK_ENTRY(lookup_widget(member_dialog, "town")), member.town);
	  gtk_entry_set_text(GTK_ENTRY(lookup_widget(member_dialog, "state")), member.state);
	  gtk_entry_set_text(GTK_ENTRY(lookup_widget(member_dialog, "zip")), member.zipcode);
	  gtk_entry_set_text(GTK_ENTRY(lookup_widget(member_dialog, "phone")), member.phone);

	   gtk_window_set_title(GTK_WINDOW(member_dialog), _("Edit Member"));
	}
      gtk_widget_show (member_dialog);
    }
}

void
on_member_dialog_clicked               (GnomeDialog     *gnomedialog,
                                        gint             arg1,
                                        gpointer         user_data)
{
  GtkWidget *b;
  GtkWidget *message_box;
  gchar *msg;
  gchar *member_no;
  gint member_id = 0;

  if (arg1 == GNOME_OK)
    {
      dvd_store_member new_member;
      
      b = GTK_WIDGET(gnomedialog);

      gtk_label_get(GTK_LABEL(lookup_widget(b, "member_no")), &member_no);
      strncpy((new_member.member_no), member_no, 6);

      strncpy((new_member.title), 
	      gtk_entry_get_text(GTK_ENTRY(lookup_widget(b, "title"))), 4);
      strncpy((new_member.fname), 
	      gtk_entry_get_text(GTK_ENTRY(lookup_widget(b, "first_name"))), 26);
      strncpy((new_member.lname), 
	      gtk_entry_get_text(GTK_ENTRY(lookup_widget(b, "last_name"))), 26);
      strncpy((new_member.house_flat_ref), 
	      gtk_entry_get_text(GTK_ENTRY(lookup_widget(b, "house_flat_ref"))), 26);
      strncpy((new_member.address1), 
	      gtk_entry_get_text(GTK_ENTRY(lookup_widget(b, "address_1"))), 51);
      strncpy((new_member.address2), 
	      gtk_entry_get_text(GTK_ENTRY(lookup_widget(b, "address_2"))), 51);
      strncpy((new_member.town), 
	      gtk_entry_get_text(GTK_ENTRY(lookup_widget(b, "town"))), 51);
      strncpy((new_member.state), 
	      gtk_entry_get_text(GTK_ENTRY(lookup_widget(b, "state"))), 3);
      strncpy((new_member.zipcode), 
	      gtk_entry_get_text(GTK_ENTRY(lookup_widget(b, "zip"))), 11);
      strncpy((new_member.phone), 
	      gtk_entry_get_text(GTK_ENTRY(lookup_widget(b, "phone"))), 31);
      
      if (dvd_member_get_id_from_number(member_no, &member_id) == DVD_SUCCESS)
	{
	  new_member.member_id = member_id;
	  dvd_gui_show_result("member_set", dvd_member_set(&new_member));
	}
      else 
	{
	  dvd_gui_show_result("member_create", dvd_member_create(&new_member, &member_id));
	  dvd_gui_show_result("member_get", dvd_member_get(member_id, &new_member));
	  
	  msg = g_strdup_printf(_("%s %s %s added as a new member. Member no. %s "), 
				new_member.title, new_member.fname, 
				new_member.lname, new_member.member_no);
	  message_box = gnome_message_box_new (msg, GNOME_MESSAGE_BOX_INFO,
					       GNOME_STOCK_BUTTON_OK,
					       NULL);
	  gtk_widget_show(message_box);
	  
	  add_log_message(msg);
	  g_free(msg);
	}
    }
}



