/*
 *  main_window.c
 *  Contains code that deals with showing and updating the contents
 *  of the main window.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "interface.h"
#include "support.h"
#include "dvd.h"
#include "misc.h"
#include "dvd_gui.h"
#include "main_window.h"


void
update_on_loan_clist()
{
  GtkCList *on_loan_clist;
  gint *disk_ids; 
  gint member_id;
  gint count;
  gint i=0;
  gchar *text[3];
  gchar *date = NULL;
  dvd_title title;
  dvd_store_member member;
  dvd_disk disk;

  g_return_if_fail (main_window != NULL);
  
  on_loan_clist = GTK_CLIST(lookup_widget(main_window, "on_loan_clist"));
  if (!dvd_overdue_disks("19000101", 
			 "20010101",
			 &disk_ids,
			 &count)) {
  printf("count = %d\n", count);
  gtk_clist_freeze(on_loan_clist);
  while (count--) {  
    dvd_gui_show_result("rented_disk_info", dvd_rented_disk_info(disk_ids[i++],
								 &member_id,
								 date));
    dvd_gui_show_result("dvd_get_disk", dvd_disk_get(disk_ids[i],
						     &disk));
    dvd_gui_show_result("dvd_title_get", dvd_title_get(disk.title_id,
						       &title));
    dvd_gui_show_result("dvd_member_get", dvd_member_get(member_id,
							 &member));
    text[0] = member.member_no;
    text[1] = member.fname;
    text[2] = title.title_text;
    gtk_clist_prepend(on_loan_clist, text); 
    }
  gtk_clist_thaw(on_loan_clist);
  }
}














