/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "interface.h"
#include "support.h"
#include "dvd_gui.h"
#include "dvd.h"
#include "misc.h"
#include "main_window.h"
#include "session.h"

/* Set up connections to CORBA-based services */
void ConnectORB (int argc, char *argv[]);  

struct poptOption options[] = 
  {
    {
      "username",
      'u',
      POPT_ARG_STRING,
      &user,
      0,
      N_("Specify a user"),
      N_("USER")
    },
    {
      "password",
      'p',
      POPT_ARG_STRING,
      &passwd,
      0,
      N_("Specify a password"),
      N_("PASSWORD")
    },
    {
      NULL,
      '\0',
      0,
      NULL,
      0,
      NULL,
      NULL
    }
  };

int
main (int argc, char *argv[])
{
  GnomeClient *client; 

 #ifdef ENABLE_NLS
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);
#endif
  user = NULL;
  passwd = NULL; 
  /* Nowy fragment kodu dla aplikacji CORBA! */
  ConnectORB(argc, argv);  /* Podczenie do serwera DVD */
  gnome_init_with_popt_table("dvdstore", VERSION, argc, argv,
			     options, 0, NULL);

  /* Session Management */
  client = gnome_master_client();
  gtk_signal_connect (GTK_OBJECT(client), 
		      "save_yourself",
		      GTK_SIGNAL_FUNC(save_session),
		      argv[0]);
  gtk_signal_connect (GTK_OBJECT(client),
		      "die",
		      GTK_SIGNAL_FUNC (session_die),
		      NULL);

  main_window = create_dvdstore ();
  gtk_signal_connect(GTK_OBJECT(main_window),
		     "delete_event",
		     GTK_SIGNAL_FUNC(exit_dvdstore),
		     NULL);
 
  update_on_loan_clist();
  open_log_file();
  gtk_widget_show (main_window);
 
  search_window = NULL;
  gnome_appbar_push(GNOME_APPBAR(lookup_widget(main_window, 
					       "appbar1")),
		    "Not Connected");
  sensitize_widgets (main_window, FALSE);
  add_log_message(_("*** Welcome to the DVDstore ***"));
  if (user)
    dvd_store_connect();
  gtk_main ();
  return 0;
}





