/* 
 * callbacks.c 
 *
 * This file contains the callback functions called in respose to 
 * widget signals and events.
 * Empty functions are generated by Glade upon building the source 
 * code, when a callback is newly linked. Glade will not overwrite 
 * code in this file.
 * 
 */



#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "dvd.h"
#include "dvd_gui.h"
#include "misc.h"

/******************************
 * GnomeApp Menu callbacks    *
 ******************************/


void
on_connect_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  dvd_store_connect();
}


void
on_disconnect_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  dvd_store_disconnect();
}


void
on_add_member_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  do_member_dialog(0);
}


void
on_add_dvd_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  do_dvd_dialog(0);
}


void
on_exit_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  exit_dvdstore();
}


void
on_search_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 do_search_dialog();
}


void
on_return_dvd_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 do_return_dvd_dialog();
}

void
on_rent_dvd_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 do_rent_dvd_dialog(NULL, 0);
}


void
on_reserve_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  do_reserve_dialog(NULL, 0);
}


void
on_preferences_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  do_property_box();
}


void
on_about_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  do_about_dialog();
}

/*****************************
 * Toolbar buttons callbacks *
 *****************************/

void
on_connect_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  dvd_store_connect();
}


void
on_disconnect_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  dvd_store_disconnect();
}

void
on_rent_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  do_rent_dvd_dialog(NULL, 0);
}


void
on_return_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  do_return_dvd_dialog();
}


void
on_add_member_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  do_member_dialog(0);
}


void
on_search_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  do_search_dialog();
}


void
on_reserve_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  do_reserve_dialog(NULL, 0);
}


void
on_exit_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  exit_dvdstore();
}

void
on_new_disk_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  do_new_disk_dialog();  
}

/************************
 * Dialog box callbacks *
 ************************/

void
on_member_search_results_close_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_hide(lookup_widget(GTK_WIDGET (button), 
				   "member_search_results_window"));
}

