#!/usr/bin/env python
import CORBA
import sys
import time
from time import sleep

CORBA.load_idl("dvdc.idl")
orb = CORBA.ORB_init((), CORBA.ORB_ID)
ior = open("./dvd-server.ior").readline()
DVDSERVICE = orb.string_to_object(ior)
print DVDSERVICE.__repo_id

# Test utilities...
print "Instantiate utilities..."
try:
	UTILS=DVDSERVICE.UTILITIESFactory()
except:
	print "Oops.  Can't get UTILITIES"
print "Testing UTILS.today()"
try:
	print "Date is: ", UTILS.today()
except:
	print "today() failed..."
print "Testing UTILS.errortext()"
try:
	print "Error -7:", UTILS.errortext(-7)
	print "Error -11:", UTILS.errortext(-11)
	print "Error -1:", UTILS.errortext(-1)
except:
	print "Oops.  errortext() failed..."
print "Testing UTILS.getgenres()"
try:
	print "Genres are: ", UTILS.getgenres()
except:
	print "getgenres() failed..."
try:
	MBR=DVDSERVICE.MEMBERSHIPFactory()
except:
	print "Oops.  Can't get MEMBERSHIP"
try:
	cbb=DVD.MEMBERSHIP.storemembers(memberid=123, memberno="123", title="Mr", fname="Christopher", lname="Browne", houseflatref="1003", address1="400 Red River Trail", address2="", town="Irving", state="TX", phone="972-555-1212", zipcode="75063")
	print "CBB: ", cbb
	MBR.set(cbb)
	cbb=DVD.MEMBERSHIP.storemembers(memberid=234, memberno="234", title="Ms", fname="Christy", lname="Crocker", houseflatref="105", address1="401 Red River Trail", address2="", town="Irving", state="TX", phone="972-555-1213", zipcode="75063")
	print "CBB: ", cbb
	MBR.set(cbb)
except:
	print "Couldn't set value..."
try:
	person=MBR.get(123)
	print "Result for", person.memberid, " was...", person.memberno, person.title, person.fname, person.lname, person.houseflatref, person.address1, person.address2, person.town, person.state, person.phone, person.zipcode
except:
	print "Couldn't read #123"
try:
	person=MBR.get(234)
	print "Result for", person.memberid, " was...", person.memberno, person.title, person.fname, person.lname, person.houseflatref, person.address1, person.address2, person.town, person.state, person.phone, person.zipcode
except:
	print "Couldn't read #234"
try:
	person=MBR.get(135)
	print "Result for", person.memberid, " was...", person.memberno, person.title, person.fname, person.lname, person.houseflatref, person.address1, person.address2, person.town, person.state, person.phone, person.zipcode
except:
	print "Couldn't read #135"
try:
	cbb=DVD.MEMBERSHIP.storemembers(memberid=0, memberno="0", title="Mr", fname="Close", lname="Garth", houseflatref="104", address1="471 Blue Suede Trail", address2="", town="Garland", state="TX", phone="972-555-1214", zipcode="75065")
	newid=MBR.create(cbb)
	print "Created new member: %d" % newid
	cbb=DVD.MEMBERSHIP.storemembers(memberid=0, memberno="0", title="Mrs", fname="Close", lname="Arlene", houseflatref="104", address1="471 Blue Suede Trail", address2="", town="Garland", state="TX", phone="972-555-1214", zipcode="75065")
	newid=MBR.create(cbb)
	print "Created new member: %d" % newid
except:
	print "Failure to create() new members "

try:
	cbb=MBR.get(newid)
	print "Info on %d:" % newid, cbb.fname, cbb.lname, cbb.town, cbb.state
except:
	print "Could not get record for ", newid

try:
	sres=MBR.search("arlene")
	print "Looks like: ", sres
except:
	print "Couldn't do search for arlene"
try:
	print "List results from search for arlene"
	for i in sres:
		mem=MBR.get(i)
		print "Member: ", mem.memberno, " is ", mem.fname, " ", mem.lname
except:
	print "Problem getting the list of folks..."
try:
	sres=MBR.search("browne")
	print "Looks like: ", sres
except:
	print "Couldn't do search for BROWNE"
try:
	print "List results from search for BROWNE"
	for i in sres:
		mem=MBR.get(i)
		print "Member: ", mem.memberno, " is ", mem.fname, " ", mem.lname
except:
	print "Problem getting the list of folks..."
try:
	sres=MBR.search("closer")
	print "Looks like: ", sres
except:
	print "Couldn't do search for closer"
try:
	print "List results from search for closer"
	for i in sres:
		mem=MBR.get(i)
		print "Member: ", mem.memberno, " is ", mem.fname, " ", mem.lname
except:
	print "Problem getting the list of folks..."
try:
	sres=MBR.search("arlene")
	print "Looks like: ", sres
except:
	print "Couldn't do search for arlene"
try:
	for i in sres:
		mem=MBR.get(i)
		print "Member: ", mem.memberno, " is ", mem.fname, " ", mem.lname
except:
	print "Problem getting the list of folks..."

try:
	print "Try to get ID for 123 and 234"
	id = MBR.idfromnumber("123")
	id2=MBR.idfromnumber("234")
	print "Results: for 123... ", id	
	print "Results: for 234... ", id2
except: pass

print "Get ID for nonexistent number 0"
try:
	id = MBR.idfromnumber("0")
except DVD.MEMBERSHIP.NOSUCHMEMBER:
	print "Exception: No such member found ..."
except:
	print "Some other problem..."


	cbb=DVD.MEMBERSHIP.storemembers(memberid=0, memberno="0", title="Mrs", fname="Close", lname="Arlene", houseflatref="104", address1="471 Blue Suede Trail", address2="", town="Garland", state="TX", phone="972-555-1214", zipcode="75065")

print "Test TITLING"
try:
	TTL=DVDSERVICE.TITLINGFactory()
except:
	print "Oops.  Can't get TITLING"
try:
	print "Set up title..."
	ttl=DVD.TITLING.dvdtitles(titleid=456, titletext="The Fifth Element",
		asin="0123456789", director="Luc Besson", genre="SF",
		classification="PG", actor1="Bruce Willis", 
		actor2="Mila Jojovich", releasedate="19960303",
		rentalcost="3.50", image="")
	tt2=DVD.TITLING.dvdtitles(titleid=0, titletext="A New Hope",
		asin="0123456789", director="George Lucas", genre="SF",
		classification="G", actor1="Scott Something", 
		actor2="Harrison Ford", releasedate="19760303",
		rentalcost="2.50", image="")
	tt3=DVD.TITLING.dvdtitles(titleid=0, titletext="The Empire Strikes Back",
		asin="0123456789", director="George Lucas", genre="SF",
		classification="G", actor1="Scott Something", 
		actor2="Harrison Ford", releasedate="19780303",
		rentalcost="2.50", image="")
	tt4=DVD.TITLING.dvdtitles(titleid=0, titletext="Return of the Jedi",
		asin="0123456789", director="George Lucas", genre="SF",
		classification="G", actor1="Scott Something", 
		actor2="Harrison Ford", releasedate="19800303",
		rentalcost="2.50", image="")
	tt5=DVD.TITLING.dvdtitles(titleid=0, titletext="Jar Jar Binks Incredible Adventure",
		asin="0123456789", director="George Lucas", genre="SF",
		classification="G", actor1="Scott Something", 
		actor2="Harrison Ford", releasedate="20010303",
		rentalcost="9.50", image="")
except:
	print "generated some titles..."
try:
	TTL.set(ttl)
	TTL.create(ttl)
	TTL.create(tt2)
	TTL.create(tt3)
	TTL.create(tt4)
	TTL.create(tt5)
except:
	print "Couldn't set title..."
try:
	tt5=DVD.TITLING.dvdtitles(titleid=248, titletext="Jar Jar Binks Incredible Adventure",
		asin="0123456789", director="George Lucas", genre="SF",
		classification="G", actor1="Scott Something", 
		actor2="Harrison Ford", releasedate="20010303",
		rentalcost="9.50", image="")
	TTL.set(tt5)
except:
	print "Set blew..."
try:
	print "try to get a record..."
	rec = TTL.get(7)
	print "Film 7: ", rec.title, "Directed by:", rec.director
except:
	print "Couldn't get record #7"
try:
	print "try to delete record #13"
	TTL.delete(13)
	print "Ok, it's gone."
except:
	print "...Couldn't do it..."
try:
	print "Look for George Lucas"
	searchres=TTL.search("", "George Lucas")
	print "Found: ", searchres
except:
	print "Search failed utterly..."
try:
	print "Look for jar jar..."
	searchres=TTL.search("Jar Jar Binks Incredible Adventure", "none")
	print "Found: ", searchres
except:
	print "Search failed utterly..."
print "Start working the DISKS..."
DSKS=DVDSERVICE.DISKSFactory()
for i in [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]:
	for j in [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]:
		newdsk=DVD.DISKS.dvddisks(diskid=i, titleid=j)
		DSKS.create(newdsk)
try:
	DSKS.delete(8)
	print "Deleted #8"
except:
	print "Couldn't delete #8"

DSKS.set(DVD.DISKS.dvddisks(diskid=8, titleid=456))

try: 
	dsk=DSKS.get(9)
	print "Got disk: ", dsk.diskid, " title ID: ", dsk.titleid
except:
	print "Attempt to get disk failed..."
try:
	print "Search for 234..."
	res=DSKS.search(234)
	print "Result: ", res
except:
	print "Search failed..."

RNT=DVDSERVICE.RENTALFactory()
print "Testing Rentals: ", RNT

def tryrental(mem, title):
	try:
		disk = RNT.renttitle(mem, title)
		print "Rented disk: ", disk
	except DVD.DISKS.NOSUCHDISK:
		print "No disk available for :", title
	except DVD.TITLING.NOSUCHTITLE:
		print "No such title as:", title
	except DVD.MEMBERSHIP.NOSUCHMEMBER:
		print "no such member as:", mem
	except DVD.RENTAL.FORBIDDENRATING:
		print "Rental forbidden due to rating for ", member, " for title ", title
tryrental(mem=123, title=456)
tryrental(mem=234, title=6)
tryrental(mem=135, title=17)
tryrental(mem=123, title=3214)
