/* Prosty klient */
#include "stdio.h"
#include "orb/orbit.h"  /* Nagwek ORBit */
#include "msg.h"        /* Plik nagwkowy IDL */
int readlines (void);
#define MAXMSGLEN 2500   /* Maksymalna liczba wierszy w msg */
char *contents[MAXMSGLEN+1];

int main (int argc, char *argv[])
{
  /* Zmienne uywane do odczytu IOR */
  FILE *ifp; char *ior,  filebuffer[1024];  
  /* Zmienne krytyczne dla POA */
  CORBA_Environment ev;   
  CORBA_ORB orb;
  CORBA_Object msg_client;  /* cze do obiektu Message */
  
  /* Zmienne uywane do przechowywania danych wiadomoci, ktra
     ma by wysana. */
  MESSAGING_msg *ourmessage;
  MESSAGING_msgLines *mbody;
  /* Rne */
  int lines, i;

  /* Standardowa inicjacja ORB. Zauwamy, e ORB_init "zjada"
     wejcie z wiersza polece */
  CORBA_exception_init(&ev);
  orb = CORBA_ORB_init(&argc, argv, "orbit-local-orb", &ev);

  /*
   * Get the IOR (object reference). It should be written out
   * by the msg-server into the file msg.ior. So - if you
   * are running the server in the same place as the client,
   * this should be fine.
   */
  ifp = fopen("msg-server.ior","r");
  if( ifp == NULL ) {
    g_error("No echo.ior file!");
    exit(-1);
  }
  fgets(filebuffer,1024,ifp);
  ior = g_strdup(filebuffer);
  fclose(ifp);
  
  /* Now, let's get a link to the actual message interface object. */
  msg_client = CORBA_ORB_string_to_object(orb, ior, &ev);
  if (!msg_client) {
    printf("Cannot bind to %s\n", ior);
    exit(-2);
  }
  /* Now, let's set up a simple message.
     First, allocate a message structure... */
  ourmessage=MESSAGING_msg__alloc();  
  /* And attach basic fields to it. */
  if (argc < 3) {
    printf("Need two arguments: from to\n");
    exit(-3); 
  }
  ourmessage->fr=argv[1];  
  ourmessage->to=argv[2];  

  mbody = MESSAGING_msgLines__alloc();  /* Przydzielenie struktury... */
  lines =  readlines();          /* Wczytanie zawartoci */
  
  mbody->_length = lines;
  mbody->_buffer = CORBA_sequence_CORBA_string_allocbuf(lines);  
  for (i = 0; i < lines; i++) {
    mbody->_buffer[i] = contents[i];    
  }
  ourmessage->body = *mbody; /* Wczenie sekwencji do komunikatu */
  /* Teraz wysyka komunikatu... */
  MESSAGING_mail_submit(msg_client, ourmessage, &ev);
  
  /* catch any exceptions (eg, network is down) */
  if(ev._major != CORBA_NO_EXCEPTION) {
    printf("we got exception %d from submit!\n", ev._major);
    return 1;
  }
  /* Oczyszczenie zawartoci... */
  CORBA_Object_release(msg_client, &ev);
  CORBA_Object_release((CORBA_Object)orb, &ev);
  return 0;
}
/* Funkcja, ktra odczytuje zbitk wierszy i przenosi je do bufora
 */
int readlines (void) {
  char linebuff[4096];    /* Tymczasowy bufor dla wierszy... */
  int nlines, llen;
  for (nlines = 0; fgets(linebuff, 4096, stdin); !feof(stdin)) {
    llen = strlen(linebuff);
    contents[nlines] = (char*) malloc(llen+1);
    linebuff[llen-1]=0;   /* Wymuszenie ogranicznika wiersza */
    strcpy (contents[nlines], linebuff);
    nlines++;
    if (nlines >= MAXMSGLEN) {
      return nlines;
    }
  }
  return nlines;
}
