/* tree.h - definicje drzewa skadni */

/* Typy drzew */
typedef enum {
             t_block, /* Dla bloku instrukcji */
             t_join,  /* Dla instrukcji wewntrz bloku */
             t_if,    /* Dla instrukcji if */
             t_else,  /* Dla instrukcji zawartych w czciach else */
             t_assign,/* Dla przypisa */
             t_op,    /* Dla wyrae z operatorem */
             t_num,   /* Dla liczb */
             t_id,    /* Dla identyfikatorw */
} treetype;

typedef struct t {
  treetype type;
  int op;
  union {
    int numval;
    char *idval;
  } value;
  struct t *left;
  struct t *right;
} tree;

tree *mknum(int);
tree *mkid(char *);
tree *mknode(treetype, int, tree *, tree *);



