/* Definicje funkcji drzewa */

#include <stdio.h>
#include <stdlib.h>
#include "tree.h"

tree *mkid(char *id)
{
  tree *t = mknode(t_id, 0, NULL, NULL);
  t -> value.idval = id;
  return t;
}

tree *mknum(int num)
{
  tree *t = mknode(t_num, 0, NULL, NULL);
  t -> value.numval = num;
  return t;
}

tree *mknode(treetype type, int op, tree *l, tree * r)
{
  tree *t = malloc(sizeof(tree));
  t -> type = type;
  t -> op = op;
  t -> left = l;
  t -> right = r;
  return t;
}

print_tree(tree *t)
{
  if(!t) return;
  switch(t -> type) {
  case t_block:
    printf("{\n");
    print_tree(t -> left);
    printf("}\n");
    break;
  case t_join:
    print_tree(t -> left);
    if(t -> right)
      print_tree(t -> right);
    break;
  case t_if:
    printf("if( ");
    print_tree(t -> left);
    printf("\n");
    t = t -> right;
    print_tree(t -> left);
    if(t -> right) {
      printf("else\n");
      print_tree(t -> right);
    }
    break;
  case t_assign:
    print_tree(t -> left);
    printf(" = ");
    print_tree(t -> right);
    printf(";\n");
    break;
  case t_op:
    printf("(");
    print_tree(t -> left);
    printf(" %c ", t -> op);
    print_tree(t -> right);
    printf(")");
    break;
  case t_num:
    printf(" %d ", t -> value.numval);
    break;
  case t_id:
    printf(" %s ", t -> value.idval);
    break;
  }
}






