%{
#include <stdio.h>
%}

%union {
	int	numval;
	char	*idval;
}
%token tBEGIN
%token tEND
%token tIF
%token tTHEN
%token tELSE
%token tASSIGN
%token <idval> tIDENTIFIER
%token <numval> tNUMBER
%type <numval> expression

%start statement
%left '+'
%left '-'
%left '>'

%%

statement:   tIDENTIFIER tASSIGN expression { printf("assignment seen, value is %d\n", $3); }
           | tIF expression tTHEN statement
           | tIF expression tTHEN statement tELSE statement
           | tBEGIN statements tEND
;

statements:  statement
           | statement ';' statements
;

expression:  tNUMBER { $$ = $1; }
           | tIDENTIFIER { $$ = 0; /* would be lookup($1); */; }
           | expression '+' expression { $$ = $1 + $3; }
           | expression '-' expression { $$ = $1 - $3; }
           | expression '>' expression { $$ = $1 > $3; }
;

%%

int main()
{
  yyparse();
}

int yyerror(char *s)
{
  fprintf(stderr, "%s\n", s);
  return 0;
}

#include "lex.yy.c"

