/* Specyfikacja lex dla podzbioru Pascala */

%{
#include <string.h>
%}

ID [A-Za-z][A-Za-z0-9]*

%%

"begin"  { return tBEGIN; }
"end"    { return tEND; }
"if"     { return tIF; }
"then"   { return tTHEN; }
"else"   { return tELSE; }
":="     { return tASSIGN; }
{ID}     { yylval.idval = strdup(yytext); return tIDENTIFIER; }
[0-9]+   { yylval.numval = atoi(yytext); return tNUMBER; }
[ \t\n]  /* pomijanie spacji i pustych wierszy */
.        { return *yytext; }

%%
