/* LEX specification for numbers */

%{
#include <stdlib.h>
%}

EXP      "E"|"e"
DIGIT    [0-9]
DECIMAL  "."
SIGN     "+"|"-"

%option main
%%
{DIGIT}+{DECIMAL}{DIGIT}*  {
                              printf("DECIMAL(%s -> %g)", yytext, atof(yytext));
                           }
{DIGIT}+ {
            printf("INTEGER(%s -> %d)", yytext, atoi(yytext));
         }

{DIGIT}+{DECIMAL}{DIGIT}*{EXP}{SIGN}?{DIGIT}+  {
                                                  printf("REAL(%s -> %g)", yytext, atof(yytext));
                                               }
%%

