/***************************************************************

Demonstration code from 'Professional Linux Programming'

Written by Andrew Froggatt et. al.

Copyright (C) 2000 Wrox Press.

http://www.wrox.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***************************************************************/

/*
 *  Contains session managemnet functions for DVD store
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include "session.h"
#include "dvd_gui.h"
#include "misc.h"

gint
save_session (GnomeClient *client, gint phase, GnomeSaveStyle save_style,
	      gint is_shutdown, GnomeInteractStyle interact_style,
	      gint is_fast, gpointer client_data)
{
  gchar **argv;
  guint argc;

  if ( !(argv = malloc( sizeof(char *) * 6 ))) 
    {
      perror("malloc() failed");
      exit( errno );
    }
  memset( argv, 0, (sizeof(char *) * 6) );
  argc = 1;
  argv[0] = client_data;
  
  if (user && passwd)
    {
      argv[1] = "--username";
      argv[2] = user;
      argv[3] = "--password";
      argv[4] = passwd;
      argc = 5;
    }
  gnome_client_set_clone_command (client, argc, argv);
  gnome_client_set_restart_command (client, argc, argv);

  return TRUE;
}

gint
session_die (GnomeClient *client, gpointer client_data)
{
  exit_dvdstore();
  return TRUE;
}

















