/***************************************************************

Demonstration code from 'Professional Linux Programming'

Written by Andrew Froggatt et. al.

Copyright (C) 2000 Wrox Press.

http://www.wrox.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***************************************************************/


/* 
 * search_window.c
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "search_window.h"
#include "interface.h"
#include "support.h"
#include "dvd.h"
#include "misc.h"
#include "dvd_gui.h"
#include "callbacks.h"

enum search_page {
  TITLE_PAGE,
  MEMBER_PAGE,
  DISK_PAGE };

enum _member_search_type {
  MEMBER_NO,
  LAST_NAME }
member_search_type;

static gint selected_row;

GSList *title_search_slist;
GSList *member_search_slist;
GSList *disk_search_slist;

void
do_search_dialog()
{
  GtkWidget *member_optionmenu;
  GtkWidget *member_menu;

  if (search_window != NULL)
    { 
      gtk_widget_show(search_window);
    }
  else
    {
      /* Call the glade created function to create
       * the dialog, setup optionmenus and connect callbacks
       */

      search_window = create_search_window ();

      member_optionmenu = lookup_widget (search_window, "member_optionmenu");
      member_menu = create_member_optionmenu();
      
      gtk_option_menu_remove_menu (GTK_OPTION_MENU(member_optionmenu));
      gtk_option_menu_set_menu(GTK_OPTION_MENU(member_optionmenu), 
			       member_menu);
      member_search_type = MEMBER_NO;
      
      gtk_signal_connect(GTK_OBJECT(search_window),
			 "delete_event",
			 GTK_SIGNAL_FUNC(gtk_widget_hide),
			 &search_window);   
      gtk_window_set_default_size(GTK_WINDOW(search_window), 500, 500);
      update_search_window_preferences();
      gtk_widget_show (search_window);
    }
} 

void
update_title_search_clist() 
{
  dvd_title title;
  GtkCList *clist;
  gint count;
  gint id;
  gchar *text[10];
  
  count = g_slist_length(title_search_slist);
  
  clist = GTK_CLIST(lookup_widget(search_window,
				  "title_search_clist"));
  gtk_clist_clear(clist);
  gtk_clist_freeze (clist);

  while (count--) {
    id = GPOINTER_TO_INT (g_slist_nth_data(title_search_slist, count));
    dvd_title_get(id, &title);

    text[0] = g_strdup_printf("%d", id); 
    text[1] = title.title_text;
    text[2] = title.asin;
    text[3] = title.director;
    text[4] = title.genre;
    text[5] = title.classification;
    text[6] = title.actor1;
    text[7] = title.actor2;
    text[8] = title.release_date;
    text[9] = title.rental_cost;
  
    gtk_clist_prepend(clist, text);
  }

  gtk_clist_thaw (clist);
 
}

void
update_member_search_clist()

{

 dvd_store_member member;
  GtkCList *clist;
  gint count;
  gint id;
  gchar *text[11];
  
  count = g_slist_length(member_search_slist);
  
  clist = GTK_CLIST(lookup_widget(search_window,
				  "member_search_clist"));
  gtk_clist_clear(clist);
  
  gtk_clist_freeze (clist);
  while (count--) {
    id = GPOINTER_TO_INT (g_slist_nth_data(member_search_slist, count));
    dvd_member_get(id, &member);
    text[0] = member.member_no;  
    text[1] = member.title;
    text[2] = member.fname;
    text[3] = member.lname;
    text[4] = member.house_flat_ref;
    text[5] = member.address1;
    text[6] = member.address2;
    text[7] = member.town;
    text[8] = member.state;
    text[9] = member.phone;
    text[10] = member.zipcode;
  
    gtk_clist_prepend(clist, text);
  }
  gtk_clist_thaw (clist);
  
}

void
update_disk_search_clist()
{
  dvd_disk disk;
  dvd_title title;
  GtkCList *clist;
  gint count;
  gint id;
  gint member_id;
  gint result;
  gchar *text[4];
  gchar date_rented[9];
  dvd_store_member member;

  count = g_slist_length(disk_search_slist);
  clist = GTK_CLIST(lookup_widget(search_window,
				  "disk_search_clist"));
  gtk_clist_clear(clist);
  gtk_clist_freeze (clist);

  while (count--) 
    {
    id = GPOINTER_TO_INT (g_slist_nth_data(disk_search_slist, count));
    dvd_gui_show_result("dvd_disk_get", dvd_disk_get(id, &disk));
    dvd_gui_show_result("dvd_title_get", dvd_title_get(disk.title_id, &title));
    result = dvd_rented_disk_info(id, &member_id, date_rented);

    text[0] = g_strdup_printf("%d", disk.title_id);
    text[1] = title.title_text;
    text[2] = g_strdup_printf("%d", id);

    if (result != DVD_SUCCESS)
	text[3] = "";
    else
    { 
	dvd_gui_show_result("dvd_member_get", dvd_member_get(member_id, &member));
	text[3] = member.member_no;
    }
    gtk_clist_prepend(clist, text);
    }
  gtk_clist_thaw (clist);
}


void
on_search_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  /* Function to search in database 
   */
  GtkCList *clist;
  GtkWidget *entry1, *entry2, *menu, *active_item, *member_optionmenu;
  
  gchar *entry1_text;
  gchar *entry2_text;
  gchar member_no[6];
  gchar *appbar_text = NULL;

  gint diskid, current_page, id, count, member_search_type;
  gint i = 0;
  gint *ids;
  
 

  current_page = gtk_notebook_get_current_page (GTK_NOTEBOOK (lookup_widget(GTK_WIDGET (button),
									    "search_notebook")));
  member_optionmenu = lookup_widget(GTK_WIDGET(button), "member_optionmenu");
  menu = GTK_OPTION_MENU(member_optionmenu)->menu;
  active_item = gtk_menu_get_active(GTK_MENU(menu));
  member_search_type = g_list_index(GTK_MENU_SHELL(menu)->children, active_item);

  if (current_page == TITLE_PAGE) 
    {
      
      /* Wyszukiwanie tytuu filmu DVD
       */
      entry1 = lookup_widget(GTK_WIDGET (button), "title_entry");
      entry1_text = gtk_entry_get_text(GTK_ENTRY(gnome_entry_gtk_entry(GNOME_ENTRY(entry1))));
      entry2 = lookup_widget(GTK_WIDGET (button), "actor_entry");
      entry2_text = gtk_entry_get_text(GTK_ENTRY(gnome_entry_gtk_entry(GNOME_ENTRY(entry2))));
      
      dvd_gui_show_result("dvd_search", dvd_title_search(entry1_text, entry2_text, &ids, &count));
      
      clist = GTK_CLIST(lookup_widget(GTK_WIDGET(button), "title_search_clist"));
      
      
      appbar_text = g_strdup_printf(_("Found %d result(s) searching for \"%s\" with Actor/Director %s"), 
				    count, entry1_text, entry2_text);
      gnome_appbar_set_status(GNOME_APPBAR (lookup_widget(GTK_WIDGET (button), "search_appbar")), 
			      appbar_text);  
      /*gnome_entry_append_history (GNOME_ENTRY (entry1), TRUE, entry1_text);*/ 

      g_slist_free(title_search_slist);
      title_search_slist = NULL;
           
      while (count--) 
	title_search_slist = g_slist_append(title_search_slist, 
						   GINT_TO_POINTER(ids[i++]));
      update_title_search_clist();
      free(ids);
    }

  if (current_page == MEMBER_PAGE) 
    {
      /* Search for a member
       */
      entry1 = lookup_widget(GTK_WIDGET (button), "member_entry");
      entry1_text = gtk_entry_get_text(GTK_ENTRY(gnome_entry_gtk_entry(GNOME_ENTRY(entry1))));
      clist = GTK_CLIST(lookup_widget(GTK_WIDGET(button), "member_search_clist"));
      
      g_slist_free(member_search_slist);
      member_search_slist = NULL;

      if (member_search_type == MEMBER_NO) 
	{
	  strncpy(member_no, entry1_text, 6);
	  if (!dvd_member_get_id_from_number (member_no, &id)) 
	    {
	      count = 0;
	      member_search_slist = g_slist_append(member_search_slist, 
							  GINT_TO_POINTER(id));
	    }
	  else
	    count = 0;
	}
      else 
	dvd_gui_show_result("member_search", dvd_member_search(entry1_text, &ids, &count));
  
      appbar_text = g_strdup_printf("Found %d result(s) searching for \"%s\"", count, entry1_text);
      gnome_appbar_set_status(GNOME_APPBAR (lookup_widget(GTK_WIDGET (button), "search_appbar")), 
			      appbar_text);  
      /*gnome_entry_append_history (GNOME_ENTRY (entry1), TRUE, entry1_text);*/ 

      while (count--) 
	member_search_slist = g_slist_append(member_search_slist, 
						    GINT_TO_POINTER(ids[i++]));
       
      update_member_search_clist();
      if (member_search_type == LAST_NAME)
	free(ids);
    }

    if (current_page == DISK_PAGE) 
      {
     
	/* Search for a Disk
	 */
	entry1 = lookup_widget(GTK_WIDGET (button), "diskid_spinbutton");
	diskid = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (entry1));
	clist = GTK_CLIST(lookup_widget(GTK_WIDGET(button), "disk_search_clist"));
	
	dvd_gui_show_result("disk_search", dvd_disk_search(diskid, &ids, &count));
	
	g_slist_free(disk_search_slist);
	disk_search_slist = NULL; 
      
	appbar_text = g_strdup_printf("Found %d Disk(s) for Title ID %d", count, diskid );
	gnome_appbar_set_status(GNOME_APPBAR (lookup_widget(GTK_WIDGET (button), "search_appbar")), 
				appbar_text);  
      
	while (count--) 
	  disk_search_slist = g_slist_append(disk_search_slist, 
						    GINT_TO_POINTER(ids[i++]));
	update_disk_search_clist();   
   
      }
    g_free(appbar_text);  
}

void 
on_search_close_clicked                (GtkButton      *button,
					gpointer        user_data)
{
  gtk_widget_hide(search_window);
}

void
on_search_clear_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  gint current_page;
  GtkWidget *search_notebook;
  GtkWidget *clist = NULL;
  
  search_notebook = lookup_widget (GTK_WIDGET (button), "search_notebook");
  current_page = gtk_notebook_get_current_page (GTK_NOTEBOOK (search_notebook));

  switch (current_page)
    {
    case TITLE_PAGE:
      clist = lookup_widget (GTK_WIDGET (button), "title_search_clist");
      break;
    case MEMBER_PAGE: 
      clist = lookup_widget (GTK_WIDGET (button), "member_search_clist");
      break;
    case DISK_PAGE:
      clist = lookup_widget (GTK_WIDGET (button), "disk_search_clist");
      break;
    default: 
      g_assert_not_reached();
    }
  gtk_clist_clear (GTK_CLIST (clist));
  gnome_appbar_set_status(GNOME_APPBAR (lookup_widget(GTK_WIDGET (button), 
						      "search_appbar")), "Cleared");

}

gboolean
on_dvd_search_clist_button_press_event (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget *menu;
  GtkCList *clist;
  gint row, column;

  g_return_val_if_fail(widget != NULL, FALSE);

  menu = create_dvd_popup_menu();
  if (event->type == GDK_BUTTON_PRESS) 
    {
      GdkEventButton *buttonevent = (GdkEventButton *) event;
    
      if ( buttonevent->button == 3 ) 
	{
	  clist = GTK_CLIST(widget);
	  if (gtk_clist_get_selection_info(clist, 
					   buttonevent->x,
					   buttonevent->y,
					   &row,
					   &column)) {
     
	    gtk_clist_select_row(clist, row, column);
	    selected_row = row;

	    gtk_menu_popup ( GTK_MENU (menu), NULL, NULL, NULL, NULL, buttonevent->button, 0 ); 
	    return TRUE;
	  }
	}
    }
  return FALSE;
}


void
on_search_menu_rent_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gint current_page;
  gint id;

  dvd_store_member member;

  current_page = gtk_notebook_get_current_page (GTK_NOTEBOOK (lookup_widget(search_window,
									    "search_notebook")));
  if (current_page == TITLE_PAGE) 
    {
      g_return_if_fail (title_search_slist != NULL);
      id = GPOINTER_TO_INT(g_slist_nth_data(title_search_slist,
					    selected_row));
      do_rent_dvd_dialog(NULL, id);
    }
  if (current_page == MEMBER_PAGE) {
    g_return_if_fail (member_search_slist != NULL); 
    id = GPOINTER_TO_INT(g_slist_nth_data(member_search_slist,
					  selected_row));
    dvd_member_get(id, &member);  
    do_rent_dvd_dialog(member.member_no, 0);
  }
}


void
on_search_menu_edit_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 gint current_page;
 gint id;
  g_return_if_fail (search_window != NULL);

  current_page = gtk_notebook_get_current_page (GTK_NOTEBOOK (lookup_widget(search_window,
									    "search_notebook")));
  if (current_page == TITLE_PAGE) 
    {
     g_return_if_fail (title_search_slist != NULL);     
    id = GPOINTER_TO_INT(g_slist_nth_data(title_search_slist,
					  selected_row));
    do_dvd_dialog(id);
    }
  if (current_page == MEMBER_PAGE) 
    {
      g_return_if_fail (member_search_slist != NULL);
      id = GPOINTER_TO_INT(g_slist_nth_data(member_search_slist,
					    selected_row));
      do_member_dialog(id);
    }
}

void
on_search_menu_delete_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *dialog;
  gint id;
  gint reply;
  gint current_page;

  g_return_if_fail (search_window != NULL);

  current_page = gtk_notebook_get_current_page (GTK_NOTEBOOK (lookup_widget(search_window,
							      "search_notebook")));
  if (current_page == TITLE_PAGE) 
    {
      g_return_if_fail (title_search_slist != NULL);
      id = GPOINTER_TO_INT(g_slist_nth_data(title_search_slist,
					    selected_row));
      dialog = gnome_message_box_new(_("Delete this Title?"),
				     GNOME_MESSAGE_BOX_QUESTION,
				     GNOME_STOCK_BUTTON_YES,
				     GNOME_STOCK_BUTTON_NO,
				     NULL);
      gtk_widget_show(dialog);
      reply = gnome_dialog_run(GNOME_DIALOG(dialog));
    
      if (reply == GNOME_OK) {
	dvd_title_delete(id);
	title_search_slist = g_slist_remove (title_search_slist,
					     GINT_TO_POINTER(id));
	update_title_search_clist();
      }
  }
  if (current_page == MEMBER_PAGE) 
    {
      g_return_if_fail (member_search_slist != NULL); 
      id = GPOINTER_TO_INT(g_slist_nth_data(member_search_slist,
					    selected_row));
      dialog = gnome_message_box_new(_("Delete this Member?"),
				     GNOME_MESSAGE_BOX_QUESTION,
				     GNOME_STOCK_BUTTON_OK,
				     GNOME_STOCK_BUTTON_CANCEL,
				     NULL);
      reply = gnome_dialog_run(GNOME_DIALOG(dialog));
      
      if (reply == GNOME_OK) 
	{
	  dvd_member_delete(id);
	  member_search_slist = g_slist_remove (member_search_slist,
						GINT_TO_POINTER(id));
	  update_member_search_clist();
	}
    }
}

void
on_search_menu_reserve_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gint current_page;
  gint id;
  g_return_if_fail (search_window != NULL);

  current_page = gtk_notebook_get_current_page (GTK_NOTEBOOK (lookup_widget(search_window,
									    "search_notebook")));
  if (current_page == TITLE_PAGE) 
    {
      g_return_if_fail (title_search_slist != NULL);     
      id = GPOINTER_TO_INT(g_slist_nth_data(title_search_slist,
					    selected_row));
      do_reserve_dialog(0, id);
    }
  if (current_page == MEMBER_PAGE) 
    {
      g_return_if_fail (member_search_slist != NULL);
      id = GPOINTER_TO_INT(g_slist_nth_data(member_search_slist,
					    selected_row));
      do_reserve_dialog(id, 0);
    }
}












