/***************************************************************

Demonstration code from 'Professional Linux Programming'

Written by Andrew Froggatt et. al.

Copyright (C) 2000 Wrox Press.

http://www.wrox.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***************************************************************/

/*
 *  rent_dialog.c
 *  Contains code to handle the renting titles dialog 
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "interface.h"
#include "support.h"
#include "dvd.h"
#include "misc.h"
#include "dvd_gui.h"
#include "rent_dialog.h"

#define PIXMAP_HEIGHT 19
#define LABEL_SET_TEXT(field) gtk_label_set_text(GTK_LABEL(lookup_widget(rent_report_dialog, #field)), g_strdup(member.field))
  
static GSList *rent_disk_slist;

void
do_rent_dvd_dialog(gchar *default_member,
		   gint default_title)
{
  GtkSpinButton *title_id;
  GtkWidget *member_no;
  static GtkWidget *rent_dialog; 

  g_slist_free(rent_disk_slist);
  rent_disk_slist = NULL;
  if (rent_dialog != NULL)
    { 
      /* Prba przeniesienia okna na pierwszy plan
       */
      gdk_window_show(rent_dialog->window);
      gdk_window_raise(rent_dialog->window);
    }
  else
    {
      rent_dialog = create_rent_dvd_dialog();
      title_id = GTK_SPIN_BUTTON(lookup_widget(rent_dialog, 
					       "titleid_spinbutton"));
      member_no = lookup_widget(rent_dialog, "member_no_entry");
   
      if (default_title)
	gtk_spin_button_set_value(title_id, (float) default_title);
      
      if (default_member != NULL)
	gtk_entry_set_text(GTK_ENTRY(member_no), default_member);
      
      gtk_signal_connect(GTK_OBJECT(rent_dialog),
			 "destroy",
			 GTK_SIGNAL_FUNC(gtk_widget_destroyed),
			 &rent_dialog);
      gnome_dialog_set_parent(GNOME_DIALOG(rent_dialog), 
			      GTK_WINDOW(main_window));
      gnome_dialog_set_close(GNOME_DIALOG(rent_dialog),
			     TRUE);
      gtk_widget_show(rent_dialog);
    }
}


void
on_rent_dvd_dialog_clicked             (GnomeDialog     *gnomedialog,
                                        gint             arg1,
                                        gpointer         user_data)
{
  GtkWidget *rent_report_dialog;
  GtkCList *rent_result_clist;
  GdkPixmap *tick;
  GdkPixmap *cross;
  GdkBitmap *tick_mask;
  GdkBitmap *cross_mask;
  dvd_title title;
  dvd_store_member member;
  gchar *msg;
  gchar *text[4];
  gchar *pathname;
  gchar *member_no;
  gint member_id;
  gint titleid;
  gint disk_id;
  gint result;
  gint count;

  if (arg1 == GNOME_OK)
    {
      member_no = gtk_entry_get_text(GTK_ENTRY(lookup_widget
					       (GTK_WIDGET(gnomedialog), 
						"member_no_entry")));
      pathname = gnome_pixmap_file("yes.xpm");
      tick = gdk_pixmap_colormap_create_from_xpm ( NULL,
						   gtk_widget_get_default_colormap(),
						   &tick_mask, 
						   NULL, 
						   pathname );
      pathname = gnome_pixmap_file("no.xpm");
      cross = gdk_pixmap_colormap_create_from_xpm ( NULL,
						    gtk_widget_get_default_colormap(),
						    &cross_mask, 
						    NULL, 
						    pathname);
      g_free(pathname);
      
      result = dvd_member_get_id_from_number(member_no, &member_id);
      if (result != DVD_SUCCESS)
	{ 
	  dvd_gui_show_result(_("The member number is not valid"), result);
	  return;
	}
      rent_report_dialog = create_rent_report_dialog();
      rent_result_clist = GTK_CLIST(lookup_widget(rent_report_dialog,"rent_result_clist"));
      
      dvd_member_get(member_id, &member);

      LABEL_SET_TEXT(title);
      LABEL_SET_TEXT(fname);
      LABEL_SET_TEXT(lname);
      LABEL_SET_TEXT(house_flat_ref);
      LABEL_SET_TEXT(address1);
      LABEL_SET_TEXT(address2);

      gtk_frame_set_label(GTK_FRAME(lookup_widget(rent_report_dialog, "member_frame")), 
			  g_strdup_printf("Member %s",member_no)); 
      
      dvd_gui_show_result("dvd_reserve_title_cancel", dvd_reserve_title_cancel(member_id));
      count = g_slist_length(rent_disk_slist);
      while (count--) 
	{
	  titleid = GPOINTER_TO_INT(g_slist_nth_data(rent_disk_slist, count));    
	  dvd_title_get(titleid, &title);
	  
	  text[0] = g_strdup_printf("%d", titleid);
	  text[1] = g_strdup_printf("%s", title.title_text);
	  result = dvd_rent_title(member_id, titleid, &disk_id);
	  if (result == DVD_SUCCESS)
	    {
	      text[3] = g_strdup_printf("%d", disk_id);
	      msg = g_strdup_printf(_("Rented disk %d to Member: %s"), disk_id, member_no);
	      add_log_message(msg);
	      g_free(msg);
	    }
	  else
	    text[3] = "";

	  gtk_clist_prepend(rent_result_clist, text);
	  if (result == DVD_SUCCESS)
	    gtk_clist_set_pixmap(rent_result_clist, 0, 2, tick, tick_mask);
	  else
	    gtk_clist_set_pixmap(rent_result_clist, 0, 2, cross, cross_mask);
		
	}
      
      gtk_clist_set_row_height(rent_result_clist, PIXMAP_HEIGHT);
      gnome_dialog_set_close(GNOME_DIALOG(rent_report_dialog),
			     TRUE);
      gtk_widget_show(rent_report_dialog); 
    }
}

void
on_rent_dvd_dialog_add_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList *disk_clist;
  GtkWidget *titleid_spinbutton;
  gint titleid;
  dvd_title title;

  disk_clist = GTK_CLIST(lookup_widget(GTK_WIDGET(button), "rent_dvd_dialog_disk_clist"));
  titleid_spinbutton =  lookup_widget(GTK_WIDGET(button), "titleid_spinbutton");
  titleid = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(titleid_spinbutton)); 
  

  if (dvd_title_get(titleid, &title) == DVD_SUCCESS)
    {
      rent_disk_slist = g_slist_append(rent_disk_slist, 
					      GINT_TO_POINTER(titleid));
      update_rent_dvd_diskid_clist(disk_clist);
    }
}


void
on_rent_dvd_dialog_remove_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList *disk_clist;
  gint selected_row;
  gint titleid;

  disk_clist = GTK_CLIST(lookup_widget(GTK_WIDGET(button), "rent_dvd_dialog_disk_clist"));
  selected_row =  GPOINTER_TO_INT(gtk_clist_get_row_data(disk_clist, 0));
  titleid = GPOINTER_TO_INT(g_slist_nth_data(rent_disk_slist,
					     selected_row));
  rent_disk_slist = g_slist_remove(rent_disk_slist, GINT_TO_POINTER(titleid));
  update_rent_dvd_diskid_clist(disk_clist);
}


void
update_rent_dvd_diskid_clist(GtkCList *disk_clist)

{
 gchar *text[2];
 dvd_title title;
 gint titleid;
 gint result;
 gint count;

 count = g_slist_length(rent_disk_slist);
 gtk_clist_clear(disk_clist);

 while (count--) {
   titleid = GPOINTER_TO_INT (g_slist_nth_data(rent_disk_slist, count));
   dvd_title_get(titleid, &title);

   result = dvd_title_get(titleid, &title);
   if (result == DVD_SUCCESS) {
     text[0] = g_strdup_printf("%d", titleid);
     text[1] = title.title_text;
 
     gtk_clist_prepend(disk_clist, text);
   }
 }

}


void
on_rent_dvd_dialog_disk_clist_select_row
                                        (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  g_return_if_fail(clist != NULL);
  gtk_clist_set_row_data(clist, 0, GINT_TO_POINTER(row));
}












