/***************************************************************

Demonstration code from 'Professional Linux Programming'

Written by Andrew Froggatt et. al.

Copyright (C) 2000 Wrox Press.

http://www.wrox.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***************************************************************/

/*
 *  Contains miscellaneous Gnome/GTK+ gui functions for the DVD store
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <stdio.h>
#include <errno.h>

#include "interface.h"
#include "support.h"
#include "dvd.h"
#include "misc.h"
#include "dvd_gui.h"

static FILE *logfile;
static gboolean connected = FALSE; 

#define SET_SENSITIVE(widget) gtk_widget_set_sensitive(GTK_WIDGET(lookup_widget(main_window, #widget)), sensitive)

void
dvd_store_connect()
{
  GtkWidget *login_dialog;
  GtkWidget *gtk_username_entry;
  gchar *msg;
  gint reply;
  gint result;

  if (!user)
    {
      login_dialog = create_login_dialog();
      gnome_dialog_set_default(GNOME_DIALOG(login_dialog), GNOME_OK);
      gnome_dialog_editable_enters(GNOME_DIALOG(login_dialog),
				   GTK_EDITABLE(lookup_widget(login_dialog,
							      "password")));
      reply = gnome_dialog_run(GNOME_DIALOG(login_dialog));
      if (reply != GNOME_OK)
	{   
	  gtk_widget_destroy(login_dialog);
	  return;
	}
      gtk_username_entry = gnome_entry_gtk_entry(GNOME_ENTRY
						 (lookup_widget(login_dialog, "username")));
      user = g_strdup(gtk_entry_get_text(GTK_ENTRY(gtk_username_entry)));
      passwd = g_strdup(gtk_entry_get_text(GTK_ENTRY(lookup_widget(login_dialog,
								   "password"))));
      gtk_widget_destroy(login_dialog);
    }
  result = dvd_open_db_login(user, passwd);
  if (result == DVD_SUCCESS)
    {
      connected = TRUE;
      sensitize_widgets();
      gnome_appbar_push(GNOME_APPBAR(lookup_widget (main_window, 
						    "appbar1")),_("Connected"));
      msg = g_strdup_printf(_("User %s connected to the database"), user);
      add_log_message(msg);
      g_free(msg);
    }
  else
    {
      dvd_gui_show_result(_("Cannot connect to the database. Check the Username and\n Password are correct and that the database is set up correctly"), result);
      user = NULL;
      passwd = NULL;
    }
}

void
dvd_store_disconnect()
{
  g_return_if_fail(connected);

  g_print("The close result is: %d\n", dvd_close_db());
  connected = FALSE;
  user = NULL;
  passwd = NULL;
  sensitize_widgets();
  gnome_appbar_push(GNOME_APPBAR(lookup_widget (main_window, 
						"appbar1")),_("Not Connected"));
  add_log_message(_("Disconnected from the database"));
}

void
sensitize_widgets()
{
  static gboolean sensitive = FALSE;

  SET_SENSITIVE(menu_disconnect);
  SET_SENSITIVE(add_member);
  SET_SENSITIVE(new_title);
  SET_SENSITIVE(new_disk);
  SET_SENSITIVE(menu_search);
  SET_SENSITIVE(rent_dvd);
  SET_SENSITIVE(return_dvd);
  SET_SENSITIVE(reserve);
  SET_SENSITIVE(disconnect_button);
  SET_SENSITIVE(rent_button);
  SET_SENSITIVE(return_button);
  SET_SENSITIVE(add_member_button);
  SET_SENSITIVE(search_button);
  SET_SENSITIVE(reserve_button);	 

  gtk_widget_set_sensitive (GTK_WIDGET(lookup_widget(main_window,
						     "connect_button")), !sensitive);
  gtk_widget_set_sensitive (GTK_WIDGET(lookup_widget(main_window,
						     "menu_connect")), !sensitive);
  sensitive = !sensitive;
}						     

gboolean
exit_dvdstore(void)

{
  GtkWidget *dialog;
  gint reply;
  
  dialog = gnome_message_box_new(_("Are you sure you want to quit?"),
				     GNOME_MESSAGE_BOX_QUESTION,
				     GNOME_STOCK_BUTTON_YES,
				     GNOME_STOCK_BUTTON_NO,
				     NULL);
  reply = gnome_dialog_run(GNOME_DIALOG(dialog));
  if (reply != GNOME_OK)
    return TRUE;
  
  if (connected) 
    dvd_store_disconnect();
  
  gtk_main_quit ();
  return FALSE;
}

void
open_log_file(void)
{
  if ((logfile = fopen(gnome_config_get_string_with_default("/dvdstore/general/logfile_name=logfile.txt",
							    NULL) ,"a")) == NULL) 
    {
      dvd_gui_show_result(_("Cannot open logfile"), 0);
    }
}


void
add_log_message(gchar *msg)
{
  GtkText *textbox;
  gchar *text;
  gchar time_text[50];
  struct tm *time_now = NULL;
  time_t the_time;

  textbox = GTK_TEXT(lookup_widget(main_window, "text_box"));
  
  the_time = time(NULL);
  time_now = localtime(&the_time);
  strftime(time_text, sizeof(time_text), "%R %x", time_now);
 
  text = g_strdup_printf("%s -- %s\n", time_text, msg);
  gtk_text_insert(textbox, NULL, NULL, NULL, text, -1);
  if (logfile != NULL)
    fprintf(logfile, "%s -- %s\n", time_text, msg);
}

void
dvd_gui_show_result(char *msg, int err)
{
  gchar *err_msg;
  gchar *dialog_text;
  GtkWidget *dialog;

  (void) dvd_err_text(err, &err_msg);
  if (err == DVD_SUCCESS)
  g_print("%s: %s\n", msg, err_msg);
  else
    {
      dialog_text = g_strdup_printf(_("DVDStore Error:\n %s: %s"), 
				    msg, err_msg);
      dialog = gnome_message_box_new(dialog_text,
				     GNOME_MESSAGE_BOX_WARNING,
				     GNOME_STOCK_BUTTON_OK,
				     NULL);
      gtk_widget_show(dialog);
    }
}

gint
date_overdue(gchar *date)
{
  gchar *date_today;
  gint day, month, year;
  gint overdue;
  GDate *g_rent_date;
  GDate *g_date_today;
 
  dvd_today(&date_today);
  sscanf(date_today, "%04d%02d%02d", &year, &month, &day);
  g_date_today = g_date_new_dmy(day, month, year);

  sscanf(date, "%04d%02d%02d", &year, &month, &day);
  g_rent_date = g_date_new_dmy(day, month, year);

  g_date_add_days(g_rent_date, 
		  gnome_config_get_int_with_default("/dvdstore/general/days_rent=3", NULL));
 
  /* g_date_compare zwraca zero dla rwnych dat, warto ujemn jeli
   * g_rent_date jest mniejsze ni g_date_today i warto dodatni jeli
   * g_rent_date jest wiksze ni g_date_today
   */
  overdue = g_date_compare(g_rent_date, g_date_today);
  g_date_free(g_rent_date);
  g_date_free(g_date_today);
  return overdue;
}

void
do_about_dialog()
{
  GtkWidget* about_dialog = NULL;
  
  about_dialog = create_about_dialog ();
  gtk_widget_show (about_dialog);
} 
















