/***************************************************************

Demonstration code from 'Professional Linux Programming'

Written by Andrew Froggatt et. al.

Copyright (C) 2000 Wrox Press.

http://www.wrox.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***************************************************************/

/*
 *  member_dialog.c
 *  Contains code to handle adding and editing members
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "interface.h"
#include "support.h"
#include "dvd.h"
#include "misc.h"
#include "dvd_gui.h"
#include "member_dialog.h"

#define ENTRY_SET_TEXT(field) gtk_entry_set_text(GTK_ENTRY(lookup_widget(member_dialog, #field)), member.field)
#define ENTRY_GET_TEXT(field, field_len) strncpy((new_member.field), gtk_entry_get_text(GTK_ENTRY(lookup_widget(GTK_WIDGET(gnomedialog), #field))), field_len) 

void
do_member_dialog(gint member_id_to_edit)
{
  dvd_store_member member;
  static GtkWidget* member_dialog = NULL;
  if (member_dialog != NULL)
    { 
      /* Prba wywoania okna na pierwszy plan
       */
      gdk_window_show(member_dialog->window);
      gdk_window_raise(member_dialog->window);
    }
  else
    {
      /* Wywoanie funkcji utworzonej przez glade
       * do utworzenia okna i podczenia wywoa zwrotnych
       */
      member_dialog = create_member_dialog ();

      gtk_signal_connect(GTK_OBJECT(member_dialog),
			 "destroy",
			 GTK_SIGNAL_FUNC(gtk_widget_destroyed),
			 &member_dialog);
      gnome_dialog_set_parent(GNOME_DIALOG(member_dialog),
			      GTK_WINDOW(main_window));
      gnome_dialog_set_close(GNOME_DIALOG(member_dialog),
			     TRUE);
      if (dvd_member_get(member_id_to_edit, &member) == DVD_SUCCESS)
	{

	  gtk_label_set_text(GTK_LABEL(lookup_widget(member_dialog, "member_no")), 
			     member.member_no);
	  ENTRY_SET_TEXT(title);
	  ENTRY_SET_TEXT(fname);
	  ENTRY_SET_TEXT(lname);
	  ENTRY_SET_TEXT(house_flat_ref);
	  ENTRY_SET_TEXT(address1);
	  ENTRY_SET_TEXT(address2);
	  ENTRY_SET_TEXT(town);
	  ENTRY_SET_TEXT(state);
	  ENTRY_SET_TEXT(zipcode);
	  ENTRY_SET_TEXT(phone);

	  gtk_window_set_title(GTK_WINDOW(member_dialog), _("Edit Member"));
	}
      gtk_widget_show (member_dialog);
    }
}

void
on_member_dialog_clicked               (GnomeDialog     *gnomedialog,
                                        gint             arg1,
                                        gpointer         user_data)
{
  GtkWidget *message_box;
  gchar *msg;
  gchar *member_no;
  gint member_id = 0;

  if (arg1 == GNOME_OK)
    {
      dvd_store_member new_member;
      

      gtk_label_get(GTK_LABEL(lookup_widget(GTK_WIDGET(gnomedialog), "member_no")), &member_no);
      strncpy((new_member.member_no), member_no, MEMBER_KNOWN_ID_LEN);

      ENTRY_GET_TEXT(title, PERSON_TITLE_LEN);
      ENTRY_GET_TEXT(fname, NAME_LEN);  
      ENTRY_GET_TEXT(lname, NAME_LEN);
      ENTRY_GET_TEXT(house_flat_ref, NAME_LEN);  
      ENTRY_GET_TEXT(address1, ADDRESS_LEN);
      ENTRY_GET_TEXT(address2, ADDRESS_LEN);
      ENTRY_GET_TEXT(town, ADDRESS_LEN);
      ENTRY_GET_TEXT(state, STATE_LEN);
      ENTRY_GET_TEXT(zipcode, ZIP_CODE_LEN);
      ENTRY_GET_TEXT(phone, PHONE_NO_LEN);

        if (dvd_member_get_id_from_number(member_no, &member_id) == DVD_SUCCESS)
	{
	  new_member.member_id = member_id;
	  dvd_gui_show_result("member_set", dvd_member_set(&new_member));
	}
      else 
	{
	  dvd_gui_show_result("member_create", dvd_member_create(&new_member, &member_id));
	  dvd_gui_show_result("member_get", dvd_member_get(member_id, &new_member));
	  
	  msg = g_strdup_printf(_("%s %s %s added as a new member. Member no. %s "), 
				new_member.title, new_member.fname, 
				new_member.lname, new_member.member_no);
	  message_box = gnome_message_box_new (msg, GNOME_MESSAGE_BOX_INFO,
					       GNOME_STOCK_BUTTON_OK,
					       NULL);
	  gtk_widget_show(message_box);
	  
	  add_log_message(msg);
	  g_free(msg);
	}
    }
}



