/***************************************************************

Demonstration code from 'Professional Linux Programming'

Written by Andrew Froggatt et. al.

Copyright (C) 2000 Wrox Press.

http://www.wrox.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***************************************************************/

/*
 * Pocztkowy plik main.c utworzony przez Glade. Mona go dowolnie
 * modyfikowa. Glade nie podmienia tego pliku.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "interface.h"
#include "support.h"
#include "dvd_gui.h"
#include "dvd.h"
#include "misc.h"
#include "session.h"

  struct poptOption options[] = 
  {
    {
      "username",
      'u',
      POPT_ARG_STRING,
      &user,
      0,
      N_("Specify a user"),
      N_("USER")
    },
    {
      "password",
      'p',
      POPT_ARG_STRING,
      &passwd,
      0,
      N_("Specify a password"),
      N_("PASSWORD")
    },
    {
      NULL, '\0', 0, NULL,
      0, NULL, NULL
    }
  };



int
main (int argc, char *argv[])
{
  GnomeClient *client; 

 #ifdef ENABLE_NLS
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);
#endif

  user = NULL;
  passwd = NULL; 

  gnome_init_with_popt_table("dvdstore", VERSION, argc, argv,
			     options, 0, NULL);


  /* Session Management */
  client = gnome_master_client();
  gtk_signal_connect (GTK_OBJECT(client), 
		      "save_yourself",
		      GTK_SIGNAL_FUNC(save_session),
		      argv[0]);
  gtk_signal_connect (GTK_OBJECT(client),
		      "die",
		      GTK_SIGNAL_FUNC (session_die),
		      NULL);

  main_window = create_dvdstore ();
  gtk_signal_connect(GTK_OBJECT(main_window),
		     "delete_event",
		     GTK_SIGNAL_FUNC(exit_dvdstore),
		     NULL);
 
  open_log_file();
  gtk_widget_show (main_window);
 
  gnome_appbar_push(GNOME_APPBAR(lookup_widget(main_window, 
					       "appbar1")),
		    "Not Connected");
  sensitize_widgets (main_window, FALSE);
  add_log_message(_("*** Welcome to the DVDstore ***"));
  if (user)
    dvd_store_connect();
  gtk_main ();
  return 0;
}





