/***************************************************************

Demonstration code from 'Professional Linux Programming'

Written by Andrew Froggatt et. al.

Copyright (C) 2000 Wrox Press.

http://www.wrox.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***************************************************************/

/*
 *  disk_dialog.c 
 *  Contains code to handle creating a new disk
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "interface.h"
#include "support.h"
#include "dvd.h"
#include "misc.h"
#include "dvd_gui.h"


void 
do_new_disk_dialog()
{
  static GtkWidget* new_disk_dialog = NULL;
  if (new_disk_dialog != NULL)
    { 
      /* Try to raise and de-iconify dialog
       */
      gdk_window_show(new_disk_dialog->window);
      gdk_window_raise(new_disk_dialog->window);
    }
  else
    {
      /* Call the glade created function to create
       * the dialog and connect callbacks
       */
      new_disk_dialog = create_disk_dialog ();
      gtk_signal_connect(GTK_OBJECT(new_disk_dialog),
			 "destroy",
			 GTK_SIGNAL_FUNC(gtk_widget_destroyed),
			 &new_disk_dialog);
      gnome_dialog_set_parent(GNOME_DIALOG(new_disk_dialog),
			      GTK_WINDOW(main_window));
      gnome_dialog_set_close(GNOME_DIALOG(new_disk_dialog),
			     TRUE);
      gtk_widget_show (new_disk_dialog);
    }
}

void
on_disk_dialog_clicked                 (GnomeDialog     *gnomedialog,
                                        gint             arg1,
                                        gpointer         user_data)
{
  GtkWidget *message_box;
  gint disk_id = 0;
  gint result;
  gchar *msg;
  dvd_disk new_disk;

 if (arg1 == GNOME_OK)
    {
      new_disk.title_id = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON 
							   (lookup_widget
							    (GTK_WIDGET(gnomedialog),
							     "titleid_spinbutton")));
      result = dvd_disk_create(&new_disk, &disk_id);
      if (result != DVD_SUCCESS)
	{
	  dvd_gui_show_result("dvd_disk_create", result);
	  return;
	}
      dvd_gui_show_result("dvd_disk_get", dvd_disk_get(disk_id, &new_disk));
      msg = g_strdup_printf(_("Created Disk ID %d for Title ID %d"), 
			    new_disk.disk_id, 
			    new_disk.title_id); 
      message_box = gnome_message_box_new (msg, GNOME_MESSAGE_BOX_INFO,
					   GNOME_STOCK_BUTTON_OK,
					   NULL);
      gtk_widget_show(message_box);
      add_log_message(msg);  
      g_free(msg); 
    }
}












