/***************************************************************

Demonstration code from 'Professional Linux Programming'

Written by Andrew Froggatt et. al.

Copyright (C) 2000 Wrox Press.

http://www.wrox.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***************************************************************/

/* 
 * callbacks.c 
 *
 * This file contains the callback functions called in respose to 
 * widget signals and events.
 * Empty functions are generated by Glade upon building the source 
 * code, when a callback is newly linked. Glade will not overwrite 
 * code in this file.
 * 
 */



#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "dvd.h"
#include "dvd_gui.h"
#include "misc.h"

/******************************
 * GnomeApp Menu callbacks    *
 ******************************/


void
on_connect_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  dvd_store_connect();
}


void
on_disconnect_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  dvd_store_disconnect();
}


void
on_add_member_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  do_member_dialog(0);
}


void
on_add_dvd_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  do_dvd_dialog(0);
}

void
on_new_disk_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  do_new_disk_dialog();  
}

void
on_exit_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  exit_dvdstore();
}


void
on_search_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 do_search_dialog();
}


void
on_return_dvd_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 do_return_dvd_dialog();
}

void
on_rent_dvd_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 do_rent_dvd_dialog(NULL, 0);
}


void
on_reserve_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  do_reserve_dialog(0, 0);
}


void
on_preferences_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  do_property_box();
}


void
on_about_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  do_about_dialog();
}

/*****************************
 * Toolbar buttons callbacks *
 *****************************/

void
on_connect_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  dvd_store_connect();
}


void
on_disconnect_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  dvd_store_disconnect();
}

void
on_rent_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  do_rent_dvd_dialog(NULL, 0);
}


void
on_return_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  do_return_dvd_dialog();
}


void
on_add_member_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  do_member_dialog(0);
}


void
on_search_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  do_search_dialog();
}


void
on_reserve_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  do_reserve_dialog(0, 0);
}


void
on_exit_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  exit_dvdstore();
}

